/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reportes.ExcelGeneratorProcess.bos;

import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.dda.general.utilerias.ProcesosUtilerias;
import com.mx.dla.dda.general.utilerias.ShellResponseDTO;
import com.mx.dla.global.bos.BaseBO;
import com.mx.dla.global.bos.CustomResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExcelGeneratorProcessBO
extends BaseBO {
    @Autowired
    private CustomResourceLoader customResourceLoader;
    @Value(value="${excel.shellPath}")
    private String rutaShell;
    @Value(value="${excel.process.path}")
    private String rutaSoftware;
    @Value(value="${excel.process.source.path}")
    private String rutaFuentes;
    @Value(value="${excel.process.target.path}")
    private String rutaResultado;
    @Value(value="${excel.shellName}")
    private String archivoShell;
    @Value(value="${excel.process.source.style}")
    private String archivoEstilos;
    @Value(value="${excel.process.tipo}")
    private String tipo;
    @Value(value="${excel.process.bloqueo}")
    private String bloqueo;
    @Value(value="${excel.process.password}")
    private String password;

    public InputStream generaExcelProceso(String xmlTablaNombre, String xlsArchivoNombre) throws IOException {
        this.logger.info("{} {}", (Object)this.rutaShell, (Object)this.rutaSoftware);
        this.logger.info("{} {}", (Object)this.rutaFuentes, (Object)this.rutaResultado);
        this.logger.info("{} {}", (Object)this.archivoShell, (Object)this.tipo);
        this.logger.info("{} {}", (Object)this.bloqueo, (Object)this.password);
        ShellResponseDTO response = ProcesosUtilerias.ejecutaShell((String[])new String[]{this.rutaShell + "/" + this.archivoShell, this.rutaSoftware, this.rutaFuentes, this.rutaResultado, xmlTablaNombre, this.archivoEstilos, xlsArchivoNombre, this.tipo, this.bloqueo, this.password});
        for (String item : ListaUtilerias.safeList((List)response.getOutputData())) {
            this.logger.info("{}", (Object)item);
        }
        for (String item : ListaUtilerias.safeList((List)response.getErrorData())) {
            this.logger.info("{}", (Object)item);
        }
        String absoluteFileName = this.rutaResultado + "/" + xlsArchivoNombre;
        return new ByteArrayInputStream(FileUtils.readFileToByteArray((File)FileUtils.getFile((String[])new String[]{absoluteFileName})));
    }

    public String guardaFuenteProceso(byte[] stream, String fileName) throws IOException {
        String absoluteFileName = this.rutaFuentes + "/" + fileName;
        this.logger.info("{}", (Object)absoluteFileName);
        File d = new File(absoluteFileName);
        d.setExecutable(true, false);
        d.setReadable(true, false);
        d.setWritable(true, false);
        FileUtils.writeByteArrayToFile((File)d, (byte[])stream);
        return new String();
    }

    public String generaFuenteProceso(List<HashMap<String, String>> data, String nombreArchivo) throws IOException, InvalidFormatException {
        byte[] tempoFile = this.customResourceLoader.getFile2ByteArray("classpath:tempoFiles/plantilla.xml");
        this.guardaFuenteProceso(tempoFile, nombreArchivo);
        return new String();
    }
}

