/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.transacciones.bos;

import com.mx.dla.dda.admin.catalogos.transacciones.daos.TransaccionesDAO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.CategoriasDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ConfiguracionesDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ExcepcionesTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ReporteGeneralDTO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransaccionesBO
extends BaseBO {
    @Autowired
    TransaccionesDAO transacciones;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;

    public List<ExcepcionesTransDTO> getExcepciones() {
        return this.transacciones.getExcepciones();
    }

    public List<CategoriasDTO> getCategorias() {
        return this.transacciones.getCategorias();
    }

    public List<EstudiosTransDTO> getEstudiosTrans() {
        return this.transacciones.getEstudiosTrans();
    }

    public void agregarExcepcion(ExcepcionesTransDTO excepcion) {
        this.transacciones.agregarExcepcion(excepcion);
    }

    public void agregarCategoria(CategoriasDTO categoria) {
        this.transacciones.agregarCategoria(categoria);
    }

    public void agregarEstudioTrans(EstudiosTransDTO estudio) {
        this.transacciones.agregarEstudioTrans(estudio);
    }

    public void eliminarEstudio(EstudiosTransDTO estudio) {
        this.transacciones.eliminarEstudio(estudio);
    }

    public void eliminarCategoria(CategoriasDTO categoria) {
        this.transacciones.eliminarCategoria(categoria);
    }

    public void eliminarExcepcion(ExcepcionesTransDTO excepcion) {
        this.transacciones.eliminarExcepcion(excepcion);
    }

    public CategoriasDTO getCategoriaById(String idCategoria) {
        return this.transacciones.getCategoriaById(idCategoria);
    }

    public void updateCategoria(CategoriasDTO categoria) {
        this.transacciones.updateCategoria(categoria);
    }

    public EstudiosTransDTO getEstudioTransById(String idEstudio) {
        return this.transacciones.getEstudioTransById(idEstudio);
    }

    public void updateEstudioTrans(EstudiosTransDTO estudio) {
        this.transacciones.eliminarEstudioByName(estudio);
        this.transacciones.agregarEstudioTrans(estudio);
    }

    public ExcepcionesTransDTO getExcepcionesById(String idExcepcion) {
        return this.transacciones.getExcepcionesById(idExcepcion);
    }

    public void updateExcepcion(ExcepcionesTransDTO excepcion) {
        this.transacciones.updateExcepcion(excepcion);
    }

    public List<ReporteGeneralDTO> reporteGeneral(String anio, String mes, String estudio) {
        return this.transacciones.reporteGeneral(anio, mes, estudio);
    }

    public InputStream obtenerReporteEnExcel(String anio, String mes, String estudio) {
        byte[] info = null;
        ByteArrayInputStream reporteGeneral = null;
        List reporte = null;
        try {
            this.logger.debug("antes de reporte");
            reporte = this.transacciones.reporteGeneral(anio, mes, estudio);
            this.logger.debug("Regresando reporte");
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
            this.logger.debug("No regresa reporte ");
        }
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("reporteTransaccionesGeneral");
        try {
            info = this.excelMapperTransform.transformObjectToExcel(reporte, mapper, ReporteGeneralDTO.class);
            reporteGeneral = new ByteArrayInputStream(info);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return reporteGeneral;
    }

    public ExcepcionesTransDTO validaExcepcionExistente(ExcepcionesTransDTO excepcion) {
        return this.transacciones.validaExcepcionExistente(excepcion);
    }

    public ConfiguracionesDTO validaMescerrado(ExcepcionesTransDTO excepcion) {
        return this.transacciones.validaMesCerrado(excepcion);
    }

    public void cerrarRporte(String fecha) {
        this.transacciones.cerrarReporte(fecha, "FECHA_CIERRE_TRANS");
    }

    public void reabrirReporte(String mes, String anio) {
        this.transacciones.reabrirReporte(mes, anio);
    }
}

