/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.generales.bos;

import com.mx.dla.dda.contrato.generales.daos.OpcionesContratoDAO;
import com.mx.dla.dda.contrato.generales.dtos.BundleReturn;
import com.mx.dla.dda.contrato.generales.dtos.CambioEstatusDTO;
import com.mx.dla.dda.contrato.generales.dtos.ProcesoPendienteDTO;
import com.mx.dla.dda.contrato.generales.enums.CatalogoTipo;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.generales.enums.MensajeTexto;
import com.mx.dla.dda.contrato.generales.enums.TipoMensaje;
import com.mx.dla.global.bos.BaseBO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpcionesContratoBO
extends BaseBO {
    @Autowired
    private OpcionesContratoDAO opcionesContratoDAO;

    public void insertaComponentesContrato(Long idContrato, List<Long> idsComponentes, CatalogoTipo tipo) {
        Integer noTitulosEnServicio = null;
        for (Long idComponente : idsComponentes) {
            try {
                if (tipo.equals((Object)CatalogoTipo.CATEGORIA)) {
                    this.opcionesContratoDAO.insertarCategoria(idContrato, idComponente);
                    continue;
                }
                if (tipo.equals((Object)CatalogoTipo.SERVICIO)) {
                    noTitulosEnServicio = this.opcionesContratoDAO.verificaPorcentajeTitulosEnServicio(idContrato, idComponente);
                    if (noTitulosEnServicio != null) continue;
                    this.opcionesContratoDAO.insertarServicio(idContrato, idComponente);
                    continue;
                }
                if (tipo.equals((Object)CatalogoTipo.TERRITORIO)) {
                    this.opcionesContratoDAO.insertarTerritorio(idContrato, idComponente);
                    continue;
                }
                if (tipo.equals((Object)CatalogoTipo.MEDIO)) {
                    this.opcionesContratoDAO.insertarMedioEntrega(idContrato, idComponente);
                    continue;
                }
                if (tipo.equals((Object)CatalogoTipo.FILIAL)) {
                    this.opcionesContratoDAO.insertarFilial(idContrato, idComponente);
                    continue;
                }
                if (!tipo.equals((Object)CatalogoTipo.TYPE)) continue;
                this.opcionesContratoDAO.insertarType(idContrato, idComponente);
            }
            catch (Exception ex) {
                this.logger.error("", (Throwable)ex);
            }
        }
    }

    public void registraTipoAmortizacion(Long idContrato, String tipoAmortizacion) {
        try {
            this.opcionesContratoDAO.registraTipoAmortizacion(idContrato, tipoAmortizacion);
        }
        catch (Exception e) {
            this.logger.error("Error : ", (Throwable)e);
        }
    }

    public void eliminaComponentes(Long idContrato, CatalogoTipo tipo) {
        try {
            if (tipo.equals((Object)CatalogoTipo.CATEGORIA)) {
                this.opcionesContratoDAO.eliminarCategorias(idContrato);
            } else if (tipo.equals((Object)CatalogoTipo.SERVICIO)) {
                this.opcionesContratoDAO.eliminarServicios(idContrato);
            } else if (tipo.equals((Object)CatalogoTipo.TERRITORIO)) {
                this.opcionesContratoDAO.eliminarTerritorios(idContrato);
            } else if (tipo.equals((Object)CatalogoTipo.MEDIO)) {
                this.opcionesContratoDAO.eliminarMediosEntrega(idContrato);
            } else if (tipo.equals((Object)CatalogoTipo.FILIAL)) {
                this.opcionesContratoDAO.eliminarFiliales(idContrato);
            } else if (tipo.equals((Object)CatalogoTipo.TYPE)) {
                this.opcionesContratoDAO.eliminarTypes(idContrato);
            } else if (tipo.equals((Object)CatalogoTipo.AREA)) {
                this.opcionesContratoDAO.eliminarContratoArea(idContrato);
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
    }

    public void actualizaTipoAmortizacion(Long idContrato, String tipoAmortizacion) {
        try {
            this.opcionesContratoDAO.actualizaTipoAmortizacion(idContrato, tipoAmortizacion);
        }
        catch (Exception e) {
            this.logger.error("Error : ", (Throwable)e);
        }
    }

    public void actulizaEstatus(Long idEstatus, Long idContrato, String expediente) {
        CambioEstatusDTO cambioEstatusDTO = new CambioEstatusDTO();
        try {
            this.opcionesContratoDAO.actualizaEstatus(idEstatus, idContrato);
            cambioEstatusDTO.setIdEstatus(idEstatus);
            cambioEstatusDTO.setIdContrato(idContrato);
            cambioEstatusDTO.setExpediente(expediente);
            cambioEstatusDTO.setFechaEstatus(new Date());
            this.opcionesContratoDAO.registraCambioEstatus(cambioEstatusDTO);
        }
        catch (Exception ex) {
            this.logger.info("", (Throwable)ex);
        }
    }

    public boolean tieneFechaAutorizacion(Long idContrato) {
        boolean respuesta = false;
        Date fechaAutorizacion = null;
        try {
            fechaAutorizacion = this.opcionesContratoDAO.obtenerFechaAutorizacion(idContrato);
            if (fechaAutorizacion != null) {
                respuesta = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public void actualizaFechaAutorizacion(Date fechaAutorizacion, Long idContrato) {
        try {
            this.opcionesContratoDAO.actualizaFechaAutorizacion(fechaAutorizacion, idContrato);
        }
        catch (Exception ex) {
            this.logger.debug("Error : [{}]", (Throwable)ex);
        }
    }

    public void ponEnNullMesesPjeExclusivo(Long idContrato) {
        try {
            this.opcionesContratoDAO.ponEnNullMesesPjeExclusivo(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
    }

    public Long actualizaEstatusPadreContrato(Long idContrato, String expediente) {
        Long idPadre = null;
        Long estatusPadre = null;
        try {
            idPadre = this.opcionesContratoDAO.obtenerIdPadreContrato(idContrato);
            estatusPadre = this.opcionesContratoDAO.obtenerEstatusPadreContrato(idPadre);
            this.logger.debug("idPadre: {}", (Object)idPadre);
            this.logger.debug("estatusPadre: {}", (Object)estatusPadre);
            if (idContrato.longValue() != idPadre.longValue()) {
                this.logger.debug("paso evaluacion: idContrato ({}) vs idPadre ({})", (Object)idContrato, (Object)idPadre);
                if (estatusPadre.longValue() == Estatus.Vigente.getValor().longValue()) {
                    this.logger.debug("paso evaluacion: estatusPadre ({}) vs Estatus.Vigente ({})", (Object)estatusPadre, (Object)Estatus.Vigente.getValor());
                    this.actulizaEstatus(Estatus.Autorizado.getValor(), idPadre, expediente);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return idPadre;
    }

    public void registraProcesoPendiente(Long idContrato, String clave, Integer estatus) {
        ProcesoPendienteDTO procesoPendiente = new ProcesoPendienteDTO();
        procesoPendiente.setClave(clave);
        procesoPendiente.setIdContrato(idContrato);
        procesoPendiente.setEstatus(estatus);
        try {
            this.opcionesContratoDAO.registraProcesoPendiente(procesoPendiente);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
    }

    public boolean esContratoAmortizable(Long idContrato) {
        boolean respuesta = false;
        String valor = "";
        try {
            valor = this.opcionesContratoDAO.obtenerValorAmortizable(idContrato);
            if (valor.equals("SI")) {
                respuesta = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public String obtenerNumeroContrato(Long idContrato) {
        String numeroContrato = "";
        try {
            numeroContrato = this.opcionesContratoDAO.obtenerNumeroContrato(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("Erro : [{}]", (Throwable)ex);
        }
        return numeroContrato;
    }

    public boolean llamarAjustaAddendum(Long idContrato) {
        boolean respuesta = true;
        HashMap<String, Long> parametroSP = new HashMap<String, Long>();
        parametroSP.put("idContrato", idContrato);
        try {
            this.opcionesContratoDAO.llamarAjustaAddendum(parametroSP);
        }
        catch (Exception ex) {
            this.logger.debug("Fallo SP AjustaAddendum : [{}]", (Throwable)ex);
            respuesta = false;
        }
        return respuesta;
    }

    public boolean llamarReportePagos(Long idContrato) {
        boolean respuesta = true;
        HashMap<String, Long> parametroSP = new HashMap<String, Long>();
        parametroSP.put("idContrato", idContrato);
        try {
            this.opcionesContratoDAO.llamarReportePagos(parametroSP);
        }
        catch (Exception ex) {
            this.logger.debug("Fallo SP llamarReportePagos : [{}]", (Throwable)ex);
            respuesta = false;
        }
        return respuesta;
    }

    public boolean llamarAmortizacionInicial(Long idContrato) {
        boolean respuesta = true;
        HashMap<String, Long> parametroSP = new HashMap<String, Long>();
        parametroSP.put("idContrato", idContrato);
        try {
            this.opcionesContratoDAO.llamarAmortizacionInicial(parametroSP);
        }
        catch (Exception ex) {
            this.logger.debug("Fallo SP llamarAmortizacionInicial : [{}]", (Throwable)ex);
            respuesta = false;
        }
        return respuesta;
    }

    public boolean llamarAmortizacionCpv(Long idContrato) {
        boolean respuesta = true;
        HashMap<String, Long> parametroSP = new HashMap<String, Long>();
        parametroSP.put("idContrato", idContrato);
        try {
            this.opcionesContratoDAO.llamarAmortizacionCpv(parametroSP);
        }
        catch (Exception ex) {
            this.logger.debug("Fallo SP llamarAmortizacionInicial : [{}]", (Throwable)ex);
            respuesta = false;
        }
        return respuesta;
    }

    public BundleReturn cancelarContrato(Date fechaCancelacion, Long idContrato, String expedienteUsuario, Long tipoContrato) {
        BundleReturn respuesta = new BundleReturn();
        List idFacturas = null;
        respuesta.setCadena(MensajeTexto.CONTRATO_NO_CANCELADO.getTexto());
        respuesta.setNumero(Integer.valueOf(TipoMensaje.ERROR.getValor()));
        respuesta.setEstado(Boolean.valueOf(false));
        try {
            idFacturas = this.opcionesContratoDAO.obtenerIdFacturas(fechaCancelacion, idContrato);
            if (idFacturas.size() == 0) {
                respuesta.setCadena(MensajeTexto.CONTRATO_CANCELADO.getTexto());
                respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
                respuesta.setEstado(Boolean.valueOf(true));
                this.actulizaEstatus(Estatus.Cancelado.getValor(), idContrato, expedienteUsuario);
                if (tipoContrato != 2L) {
                    this.opcionesContratoDAO.eliminaDespuesFechaCancelacion(fechaCancelacion, idContrato);
                }
                this.opcionesContratoDAO.actualizafechaCancelacion(fechaCancelacion, idContrato);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public void insertaTotalTitulos(Long idContrato, Integer totalTitulos) {
        try {
            this.logger.info("Insertando Total Titulos");
            this.opcionesContratoDAO.insertaTotalTitulos(idContrato, totalTitulos);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
    }

    public boolean validaTotalTitulos(Long idContrato) {
        Long idConQuery = null;
        boolean resp = false;
        try {
            this.logger.info("Valida Total Titulos");
            idConQuery = this.opcionesContratoDAO.validaTotalTitulos(idContrato);
            if (idConQuery != null) {
                resp = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return resp;
    }

    public void actualizaTotalTitulos(Long idContrato, Integer totalTitulos) {
        try {
            this.logger.info("Actualiza Total Titulos");
            this.opcionesContratoDAO.actulizaTotalTitulos(idContrato, totalTitulos);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
    }

    public void actualizaEstadosBypassWorkflow(Long idContrato, String expediente) {
        this.opcionesContratoDAO.actualizaEstatus(Estatus.Notificacion.getValor(), idContrato);
        this.opcionesContratoDAO.completaWorkflowContrato(idContrato, expediente);
    }
}

