/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.license.terminos.bos;

import com.mx.dla.dda.contrato.license.exceptions.dtos.LicenseException;
import com.mx.dla.dda.contrato.license.terminos.daos.TerminosFeeDAO;
import com.mx.dla.dda.contrato.materiales.daos.MaterialesDAO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.terminos.dtos.PagoTerminoDTO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoBD;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminosFeeBO
extends BaseBO {
    @Autowired
    private TerminosFeeDAO terminosDAO;
    @Autowired
    private MaterialesDAO materialesDAO;

    public TerminoDTO getTerminos(Long idContrato) throws LicenseException {
        TerminoDTO termino = new TerminoDTO();
        try {
            TerminoBD term = this.terminosDAO.getTermino(idContrato);
            if (term == null) {
                termino.setVacio(Boolean.valueOf(true));
            } else {
                if (term.getAnticipoMonto() != null) {
                    PagoTerminoDTO pago = new PagoTerminoDTO(Double.valueOf(Double.parseDouble(term.getAnticipoMonto())), term.getAnticipoComentario(), this.getFecha(term.getAnticipoFecha()));
                    termino.setPagoAnticipado(pago);
                }
                if (term.getTipoPago() != null && term.getTipoPago().compareTo("MENSUAL") == 0) {
                    termino.setPagoMensual(Boolean.valueOf(true));
                }
                if (term.getTipoPago() != null && term.getTipoPago().compareTo("PREDEFINIDO") == 0 && term.getTipoPredefinido().compareTo("EXHIBICION") == 0) {
                    termino.setPagoInicioExhibicion(Boolean.valueOf(true));
                }
                if (term.getTipoPago() != null && term.getTipoPago().compareTo("PREDEFINIDO") == 0 && term.getTipoPredefinido().compareTo("PERIODICO") == 0) {
                    List periodicos = this.terminosDAO.getTerminoPeriodicos(idContrato);
                    ArrayList<PagoTerminoDTO> pagoPeriodicos = new ArrayList<PagoTerminoDTO>();
                    for (TerminoBD pago : periodicos) {
                        PagoTerminoDTO pagoT = new PagoTerminoDTO(Double.valueOf(Double.parseDouble(pago.getMonto())), pago.getComentario(), this.getFecha(pago.getFecha()));
                        pagoPeriodicos.add(pagoT);
                    }
                    termino.setPagoPeriodicos(pagoPeriodicos);
                }
                termino.setComentario(term.getComentarioGeneral());
                int numero = term.getTotalTitulos() == null ? 0 : Integer.parseInt(term.getTotalTitulos());
                termino.setNumeroTitulos(Integer.valueOf(numero));
                double costo = term.getCosto() == null ? 0.0 : Double.parseDouble(term.getCosto());
                termino.setCostoContrato(Double.valueOf(costo));
            }
            return termino;
        }
        catch (PersistenceException ibe) {
            throw new LicenseException("Ocurri\u00f3 un error al obtener los datos.", (Throwable)ibe);
        }
        catch (Exception e) {
            throw new LicenseException("Ocurri\u00f3 un error al obtener los datos.", (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarTerminos(String json, Long idContrato) throws LicenseException {
        try {
            this.logger.debug(json);
            ObjectMapper mapper = new ObjectMapper();
            TerminoDTO termino = (TerminoDTO)mapper.readValue(json, TerminoDTO.class);
            TerminoBD terminobd = new TerminoBD();
            terminobd.setIdContrato(idContrato);
            this.eliminarTerminos(idContrato);
            if (termino.getPagoAnticipado() != null) {
                terminobd.setAnticipoComentario(URLDecoder.decode(termino.getPagoAnticipado().getDescripcion(), "UTF-8"));
                terminobd.setAnticipoFecha(this.crearFecha(termino.getPagoAnticipado().getFecha()));
                terminobd.setAnticipoMonto(String.valueOf(termino.getPagoAnticipado().getMonto()));
            }
            if (termino.getPagoMensual() != null && termino.getPagoMensual().booleanValue()) {
                terminobd.setTipoPago("MENSUAL");
            }
            if (termino.getPagoInicioExhibicion() != null && termino.getPagoInicioExhibicion().booleanValue()) {
                terminobd.setTipoPago("PREDEFINIDO");
                terminobd.setTipoPredefinido("EXHIBICION");
            }
            if (termino.getPagoPeriodicos() != null) {
                terminobd.setTipoPago("PREDEFINIDO");
                terminobd.setTipoPredefinido("PERIODICO");
            }
            terminobd.setComentarioGeneral(URLDecoder.decode(termino.getComentario(), "UTF-8"));
            String numTitulos = termino.getNumeroTitulos() == null ? null : String.valueOf(termino.getNumeroTitulos());
            String costo = termino.getCostoContrato() == null ? null : String.valueOf(termino.getCostoContrato());
            terminobd.setTotalTitulos(numTitulos);
            terminobd.setCosto(costo);
            this.terminosDAO.guardarTermino(terminobd);
            if (termino.getPagoPeriodicos() != null) {
                ArrayList<TerminoBD> pagoPeriodicos = new ArrayList<TerminoBD>();
                for (PagoTerminoDTO pago : termino.getPagoPeriodicos()) {
                    TerminoBD pagoT = new TerminoBD();
                    pagoT.setMonto(String.valueOf(pago.getMonto()));
                    pagoT.setFecha(this.crearFecha(pago.getFecha()));
                    pagoT.setComentario(URLDecoder.decode(pago.getDescripcion(), "UTF-8"));
                    pagoT.setIdContrato(idContrato);
                    pagoPeriodicos.add(pagoT);
                }
                this.terminosDAO.guardarTerminoPago(pagoPeriodicos);
            }
            this.actualizarCostoTitulos(idContrato, termino.getCostoContrato(), termino.getNumeroTitulos());
        }
        catch (PersistenceException ibe) {
            throw new LicenseException("Ocurri\u00f3 un error al guardar los datos.", (Throwable)ibe);
        }
        catch (Exception e) {
            throw new LicenseException("Ocurri\u00f3 un error al guardar los datos.", (Throwable)e);
        }
    }

    private void eliminarTerminos(Long idContrato) {
        this.terminosDAO.eliminarTerminoPago(idContrato);
        this.terminosDAO.eliminarTermino(idContrato);
    }

    public ContratoConsultaDTO getInformacionContrato(Long idContrato, TerminoDTO termino) {
        Double materialesCosto = this.materialesDAO.buscarCostoTotalMateriales(idContrato);
        ContratoConsultaDTO contrato = this.terminosDAO.consultaContrato(new ContratoConsultaDTO(idContrato));
        termino.setCostoMateriales(materialesCosto);
        return contrato;
    }

    public void actualizarCostoTitulos(Long idContrato, Double costoContrato, Integer numTitulos) {
        DecimalFormat df = new DecimalFormat("#.##########");
        df.setRoundingMode(RoundingMode.CEILING);
        Double valor = costoContrato / (double)numTitulos.intValue();
        String valorS = df.format(valor);
        this.terminosDAO.actualizarCostoTitulos(idContrato, valorS);
    }

    private Date crearFecha(String valor) throws ParseException {
        SimpleDateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy");
        Date fecha = formatter1.parse(valor);
        return fecha;
    }

    private String getFecha(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(fecha);
    }
}

