/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.license.titulo.bos;

import com.mx.dla.dda.contrato.common.bos.CommonRestBO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.generales.dtos.InfoDetalleContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Movimiento;
import com.mx.dla.dda.contrato.license.terminos.daos.TerminosFeeDAO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeDAO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeDmDAO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoBD;
import com.mx.dla.dda.contrato.titulo.dtos.AmortizacionSAP;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulos.dtos.CatTitulo;
import com.mx.dla.dda.contrato.titulos.dtos.ResponseValorTituloDTO;
import com.mx.dla.global.bos.BaseBO;
import java.lang.reflect.InvocationTargetException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloFeeBussinesBO
extends BaseBO {
    @Autowired
    protected CommonRestBO commonRestBO;
    @Autowired
    protected GeneralesDAO generalesDAO;
    @Autowired
    private TituloFeeDmDAO tituloDmDAO;
    @Autowired
    protected TituloFeeDAO tituloDAO;
    @Autowired
    private TerminosFeeDAO terminosDAO;

    public String obtieneCostoTitulo(Long idContrato) {
        String valorS = null;
        try {
            TerminoBD term = this.terminosDAO.getTermino(idContrato);
            int numero = term.getTotalTitulos() == null ? 0 : Integer.parseInt(term.getTotalTitulos());
            double costo = term.getCosto() == null ? 0.0 : Double.parseDouble(term.getCosto());
            DecimalFormat df = new DecimalFormat("#.##########");
            df.setRoundingMode(RoundingMode.CEILING);
            Double valor = costo / (double)numero;
            valorS = df.format(valor);
        }
        catch (Exception e) {
            this.logger.error("Ocurrio un error al tratar de generar los costos", (Throwable)e);
        }
        return valorS;
    }

    public void actualizaCostoTituloExcel(Long idContrato) {
        try {
            TerminoBD term = this.terminosDAO.getTermino(idContrato);
            int numero = term.getTotalTitulos() == null ? 0 : Integer.parseInt(term.getTotalTitulos());
            double costo = term.getCosto() == null ? 0.0 : Double.parseDouble(term.getCosto());
            DecimalFormat df = new DecimalFormat("#.##########");
            df.setRoundingMode(RoundingMode.CEILING);
            Double valor = costo / (double)numero;
            this.tituloDAO.actualizarCostoTitulosExcel(df.format(valor), idContrato);
        }
        catch (Exception e) {
            this.logger.error("Ocurrio un error al tratar de generar los costos", (Throwable)e);
        }
    }

    public void actualizaCostoTodosLosTitulos(ContratoDTO contrato) {
        try {
            ResponseValorTituloDTO response = this.commonRestBO.llamadaCostoTitulo(contrato.getFechaInicio(), contrato.getIdContrato(), "ESPEJO");
            if (!response.getResultado()) {
                this.logger.error("No fue posible actualizar el costo razon:[{}]", (Object)response.getMensaje());
            }
        }
        catch (Exception e) {
            this.logger.error("Ocurrio un error al tratar de generar los costos", (Throwable)e);
        }
    }

    public CatTitulo actualizaCatalogoTitulos(String descTitulo, ContratoDTO contrato) {
        CatTitulo ct = this.tituloDAO.buscarCatalogoTituloPorDesc(contrato.getIdEstudio(), descTitulo);
        if (ct == null) {
            ct = new CatTitulo();
            ct.setDescTitulo(descTitulo);
            ct.setIdEstudio(contrato.getIdEstudio());
            this.tituloDAO.insertarCatTitulo(ct);
        }
        return ct;
    }

    public void actualizarBanderasContratosAnteriores(Titulo titulo, String prefix) {
        InfoDetalleContratoDTO detalle = this.generalesDAO.obtenDetalleContrato(titulo.getIdContrato());
        if (detalle.getTipoMovimiento().intValue() == Movimiento.Enmienda.getValor().intValue()) {
            this.logger.info("Actualizacion banderas cambio de titulo-enmienda");
            this.logger.info(titulo.toString());
            this.tituloDmDAO.borrarRegistroSAPNUM(String.valueOf(titulo.getIdContrato()));
            SapNum anterior = this.tituloDmDAO.getAumentosDisminXTitulo(titulo.getIdTituloCntorig());
            Double aumentos = anterior == null || anterior.getAumento() == null ? 0.0 : Double.parseDouble(anterior.getAumento());
            Double disminucion = anterior == null || anterior.getDisminucion() == null ? 0.0 : Double.parseDouble(anterior.getDisminucion());
            Double diferencia = Double.parseDouble(titulo.getCosto()) - (aumentos - disminucion);
            this.logger.info("Diferencia {}", (Object)diferencia);
            if (diferencia != 0.0) {
                if (titulo.getFechaNotifsap() != null) {
                    SapNum sapNum = new SapNum(titulo.getIdContrato(), titulo.getIdTituloCnt(), titulo.getIdTituloCntorig());
                    if (diferencia > 0.0) {
                        titulo.setAjustoValor(Long.valueOf(1L));
                        sapNum.setAumento(String.valueOf(diferencia));
                    } else {
                        titulo.setAjustoValor(Long.valueOf(-1L));
                        sapNum.setDisminucion(String.valueOf(diferencia * -1.0));
                    }
                    this.tituloDmDAO.actualizarTituloVar(titulo, prefix);
                    this.tituloDmDAO.insertarSapSubnum(sapNum);
                    this.logger.info("Diferencia diferente a 0 se actuliza titulo");
                    if (sapNum.getDisminucion() != null) {
                        this.asignarDiferenciaSubNum(Double.parseDouble(sapNum.getDisminucion()), titulo.getIdTituloCntorig());
                    }
                }
            } else {
                this.logger.info("Diferencia 0 se actuliza titulo");
                titulo.setAjustoValor(Long.valueOf(0L));
                this.tituloDmDAO.actualizarTituloVar(titulo, prefix);
            }
        }
    }

    public void asignarDiferenciaSubNum(Double disminucion, Long idTituloCntOrig) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int year = cal.get(1);
        List disminuciones = this.tituloDmDAO.buscaSubNumDisminucion(idTituloCntOrig);
        List amortSub = this.tituloDmDAO.buscaMaxSubNumByFechaAmort(idTituloCntOrig, Integer.valueOf(year));
        this.logger.debug("Disminuciones {}", (Object)disminuciones.toString());
        this.logger.debug("SubNum Amorti {}", (Object)amortSub.toString());
        Double totalDisponible = 0.0;
        Boolean asignado = false;
        for (Object m : amortSub) {
            Double disponible = Double.parseDouble(m.getVnc()) - Double.parseDouble(m.getMontoAcumulado());
            totalDisponible = totalDisponible + disponible;
            if (disponible >= disminucion) {
                SapNum sapNum = this.getSapNum(((SapNum)disminuciones.get(0)).getIdContrato(), ((SapNum)disminuciones.get(0)).getIdTituloCNT(), ((SapNum)disminuciones.get(0)).getIdTituloCtoOrig(), disminucion, ((SapNum)disminuciones.get(0)).getIdRegistroSAP(), m.getSubNumero());
                this.tituloDmDAO.actualizarSubNum(sapNum);
                this.logger.debug("'disponible >= disminucion' se actualiza {} con valor {}", (Object)((SapNum)disminuciones.get(0)).getIdRegistroSAP(), (Object)disminucion);
                asignado = true;
            }
            if (!asignado.booleanValue()) continue;
            break;
        }
        this.logger.info("Se ha asignado la disminucion? {}", (Object)asignado);
        if (!asignado.booleanValue()) {
            int cont = 0;
            for (AmortizacionSAP a : amortSub) {
                SapNum sapNum;
                if (disminucion <= 0.0) break;
                Double disponible = Double.parseDouble(a.getVnc()) - Double.parseDouble(a.getMontoAcumulado());
                if (cont >= disminuciones.size()) {
                    sapNum = this.getSapNum(((SapNum)disminuciones.get(0)).getIdContrato(), ((SapNum)disminuciones.get(0)).getIdTituloCNT(), ((SapNum)disminuciones.get(0)).getIdTituloCtoOrig(), disminucion, null, a.getSubNumero());
                    if (disminucion >= disponible) {
                        sapNum.setDisminucion(String.valueOf(disponible));
                        disminucion = disminucion - disponible;
                    } else {
                        sapNum.setDisminucion(String.valueOf(disminucion));
                        disminucion = 0.0;
                    }
                    this.logger.debug("Nuevo registro con valor de amortizacion {}", (Object)disminucion);
                    this.tituloDmDAO.insertarSapSubnum(sapNum);
                } else {
                    sapNum = this.getSapNum(((SapNum)disminuciones.get(cont)).getIdContrato(), ((SapNum)disminuciones.get(cont)).getIdTituloCNT(), ((SapNum)disminuciones.get(cont)).getIdTituloCtoOrig(), null, ((SapNum)disminuciones.get(cont)).getIdRegistroSAP(), a.getSubNumero());
                    if (disminucion >= disponible) {
                        disminucion = disminucion - disponible;
                        sapNum.setDisminucion(String.valueOf(disponible));
                        this.logger.debug("'disminucion >= disponible' se actualiza {} con valor {}", (Object)((SapNum)disminuciones.get(cont)).getIdRegistroSAP(), (Object)disponible);
                        ++cont;
                    } else {
                        sapNum.setDisminucion(String.valueOf(disminucion));
                        this.logger.debug("No asignado 'disponible >= disminucion', se actualiza {} con valor {}", (Object)((SapNum)disminuciones.get(cont)).getIdRegistroSAP(), (Object)disminucion);
                        disminucion = 0.0;
                    }
                    this.tituloDmDAO.actualizarSubNum(sapNum);
                }
                this.logger.debug("disminucion {}", (Object)disminucion);
            }
            if (disminucion > 0.0) {
                this.logger.debug("Nuevo con valor {}", (Object)disminucion);
                SapNum sapNum = this.getSapNum(((SapNum)disminuciones.get(0)).getIdContrato(), ((SapNum)disminuciones.get(0)).getIdTituloCNT(), ((SapNum)disminuciones.get(0)).getIdTituloCtoOrig(), disminucion, null, null);
                this.tituloDmDAO.insertarSapSubnum(sapNum);
            }
        }
    }

    private SapNum getSapNum(Long idContrato, Long idTituloCNT, Long idTituloCNTORI, Double disminucion, Long idRegistroSap, String subnumero) {
        SapNum sapNum = new SapNum(idContrato, idTituloCNT, idTituloCNTORI);
        if (disminucion != null) {
            sapNum.setDisminucion(String.valueOf(disminucion));
        }
        if (idRegistroSap != null) {
            sapNum.setIdRegistroSAP(idRegistroSap);
        }
        if (subnumero != null) {
            sapNum.setSubnumero(subnumero);
        }
        return sapNum;
    }

    public ContratoDTO calculaFechasInicioFinValidacion(ContratoDTO contrato) {
        ContratoDTO cv = null;
        try {
            cv = (ContratoDTO)BeanUtils.cloneBean((Object)contrato);
            FechasDTO fechas = this.generalesDAO.obtenerFechasMaximaMinimaDeContratosPorContratoOriginal(contrato.getIdContratoOriginal());
            cv.setFechaInicio(fechas.getInicio());
            cv.setFechaFin(fechas.getFin());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error("Error ", (Throwable)e);
        }
        return cv;
    }
}

