/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.titulo.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TituloGridBO;
import com.mx.dla.dda.contrato.titulo.bos.TitulosBussinesBO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCargaDocumento;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloChunkDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloErrores;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.RespuestaCargaExcel;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.dtos.TitulosContratoSap;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.titulo.rules.TituloRules;
import com.mx.dla.dda.contrato.ws.cargaTitulos.CargaPrincipalDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ParamCargaCostosDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ParamCargaTitulosDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ResponseCargaTitulosDTO;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TituloBO
extends BaseBO {
    @Autowired
    protected TituloDAO tituloDAO;
    @Autowired
    protected TituloDmDAO tituloDummyDAO;
    @Autowired
    protected ListaDAO listaDAO;
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    protected TituloGridBO titulogridBO;
    @Autowired
    private TituloChunkDAO tituloChunkDAO;
    @Autowired
    protected TituloRules tituloRules;
    @Autowired
    protected TituloErrores tituloErrores;
    @Autowired
    private AmortizacionDAO amortizacionDAO;
    @Autowired
    private BeanPopulator beanPopulator;
    @Autowired
    protected TitulosBussinesBO titulosBussinesBO;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Value(value="${uri.file.titulos}")
    protected String uriErrores;
    @Value(value="${uri.file.carga.titulos}")
    protected String uriCarga;
    protected static final int CHUNK = 1000;

    public Lista init(ContratoDTO c) {
        Date a = new Date();
        Lista lista = this.listaDAO.buscarListaActual(c.getIdContrato(), "T");
        if (lista == null) {
            lista = this.crearListaNueva(c.getIdContrato(), c.getFechaInicio(), "T");
        }
        this.createMirrorEntities(c);
        lista = this.listaDAO.buscarListaActual(c.getIdContrato(), "M");
        lista.setFechaInicioPlusOneDay(this.calculaFechaMasUnDia(lista.getFechaInicio()));
        this.logger.debug("Total time ms [{}]", (Object)(new Date().getTime() - a.getTime()));
        return lista;
    }

    public List<TitulosContratoSap> recuperarTitulos(Long idContrato) {
        return this.tituloDAO.recuperarTitulosContrato(idContrato);
    }

    public Lista crearListaNueva(Long idContrato, Date fechaInicio, String prefix) {
        Lista l = new Lista(idContrato, fechaInicio, prefix);
        this.listaDAO.insertarLista(l);
        return l;
    }

    public void createMirrorEntities(ContratoDTO c) {
        this.tituloDummyDAO.borrarTitulosPorContrato(c.getIdContrato());
        this.listaDAO.borrarListaPorIdContrato(c.getIdContrato(), "M");
        this.tituloChunkDAO.aListaEspejoPorCorato(c.getIdContrato());
        List lreal = this.listaDAO.buscarListas(c.getIdContrato(), "T");
        List lespejo = this.listaDAO.buscarListas(c.getIdContrato(), "M");
        for (int i = 0; i < lreal.size(); ++i) {
            this.tituloChunkDAO.aTituloEspejoPorLista(((Lista)lreal.get(i)).getIdLista(), ((Lista)lespejo.get(i)).getIdLista());
        }
    }

    public void guardarCambiosPermanente(ContratoDTO c) throws TituloException {
        String valido = this.titulosBussinesBO.procesoActualizacionTitulosEnmienda(c.getIdContrato(), "M");
        if (valido != null) {
            throw new TituloException("Los titulos [" + valido + "] no pueden tener costo menor a su valor neto contable.");
        }
        this.titulosBussinesBO.actualizarSapnumTraslados(c.getIdContrato());
        this.tituloDAO.borrarTitulosPorContrato(c.getIdContrato());
        this.listaDAO.borrarListaPorIdContrato(c.getIdContrato(), "T");
        this.tituloChunkDAO.aListaRealPorCorato(c.getIdContrato());
        List lreal = this.listaDAO.buscarListas(c.getIdContrato(), "T");
        List lespejo = this.listaDAO.buscarListas(c.getIdContrato(), "M");
        for (int i = 0; i < lreal.size(); ++i) {
            this.tituloChunkDAO.aTituloRealPorLista(((Lista)lespejo.get(i)).getIdLista(), ((Lista)lreal.get(i)).getIdLista());
        }
        this.amortizacionDAO.updateContratoProceso(c.getIdContrato(), Integer.valueOf(1));
    }

    public byte[] generateExcelReport(Titulo titulo) throws ExcelMapperException, IOException {
        this.logger.debug("Descargar archivo de excel [{}]", (Object)titulo);
        List<Titulo> lista = new ArrayList();
        try {
            lista = this.tituloDummyDAO.buscarTituloFiltroPaginado(titulo);
            if (lista == null || lista.isEmpty()) {
                lista = new ArrayList();
                lista.add(this.beanPopulator.initObject(Titulo.class));
            }
            this.logger.debug("Descargar archivo, se han  obtenido [{}]", (Object)lista.size());
        }
        catch (Exception e) {
            this.logger.error("Error al buscar contenido de titulos::: " + e);
        }
        byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(lista, "titulo", Titulo.class);
        this.logger.debug("Descargar archivo, se ha generado binario.");
        return fileExcel;
    }

    public byte[] buscarArchivoDeErrores(ContratoDTO ct) throws IOException {
        File file = new File(this.uriErrores + ct.getIdContrato());
        this.logger.debug("busca archivo en [{}]", (Object)file.getAbsolutePath());
        byte[] errores = FileUtils.readFileToByteArray((File)file);
        return errores;
    }

    /*
     * WARNING - void declaration
     */
    public RespuestaCargaExcel actualizarCostos(ContratoDTO contrato, File fileUpload, String fileName, Titulo tit) {
        HSSFCell cellIdBroadView;
        HSSFCell cellPrecio;
        ParamCargaCostosDTO precio;
        HSSFRow row;
        HSSFRow filaCero;
        int lnuUltimaFila;
        HSSFSheet sheet;
        FileInputStream file;
        HSSFWorkbook workbook;
        ArrayList<ParamCargaCostosDTO> precios = new ArrayList<ParamCargaCostosDTO>();
        File d = null;
        try {
            byte[] f = FileUtils.readFileToByteArray((File)fileUpload);
            d = new File(fileName);
            d.setExecutable(true, false);
            d.setReadable(true, false);
            d.setWritable(true, false);
            this.logger.debug("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
            FileUtils.writeByteArrayToFile((File)d, (byte[])f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (d.getName().endsWith(".xls")) {
            workbook = null;
            try {
                file = new FileInputStream(d);
                workbook = new HSSFWorkbook((InputStream)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sheet = workbook.getSheetAt(0);
            lnuUltimaFila = sheet.getPhysicalNumberOfRows();
            this.logger.debug("leerCargaTitulosXLS[" + this.getClass().getSimpleName() + "]lnuUltimaFila: " + lnuUltimaFila);
            filaCero = sheet.getRow(0);
            if (filaCero.getCell(8).toString().toUpperCase().contains("PRECIO") && filaCero.getCell(11).toString().toUpperCase().contains("ID BROADVIEW")) {
                void var13_18;
                boolean bl = true;
                while (var13_18 < lnuUltimaFila) {
                    row = sheet.getRow((int)var13_18);
                    if (row != null) {
                        precio = new ParamCargaCostosDTO();
                        cellPrecio = row.getCell(8);
                        if (cellPrecio != null) {
                            cellPrecio.setCellType(1);
                            precio.setPrecio(cellPrecio.toString());
                        }
                        if ((cellIdBroadView = row.getCell(11)) != null) {
                            cellIdBroadView.setCellType(1);
                            precio.setIdBroadView(cellIdBroadView.toString());
                        }
                        precios.add(precio);
                    }
                    ++var13_18;
                }
            }
        }
        if (d.getName().endsWith(".xlsx")) {
            workbook = null;
            try {
                file = new FileInputStream(d);
                workbook = new XSSFWorkbook((InputStream)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sheet = workbook.getSheetAt(0);
            lnuUltimaFila = sheet.getPhysicalNumberOfRows();
            this.logger.debug("leerCargaTitulosXLS[" + this.getClass().getSimpleName() + "]lnuUltimaFila: " + lnuUltimaFila);
            filaCero = sheet.getRow(0);
            if (filaCero.getCell(8).toString().toUpperCase().contains("PRECIO") && filaCero.getCell(11).toString().toUpperCase().contains("ID BROADVIEW")) {
                void var13_20;
                boolean bl = true;
                while (var13_20 < lnuUltimaFila) {
                    row = sheet.getRow((int)var13_20);
                    if (row != null) {
                        precio = new ParamCargaCostosDTO();
                        cellPrecio = row.getCell(8);
                        if (cellPrecio != null) {
                            cellPrecio.setCellType(1);
                            precio.setPrecio(cellPrecio.toString());
                        }
                        if ((cellIdBroadView = row.getCell(11)) != null) {
                            cellIdBroadView.setCellType(1);
                            precio.setIdBroadView(cellIdBroadView.toString());
                        }
                        precios.add(precio);
                    }
                    ++var13_20;
                }
            }
        }
        RespuestaCargaExcel response = new RespuestaCargaExcel();
        ResponseCargaTitulosDTO result = new ResponseCargaTitulosDTO();
        result.setDatosCarga(new CargaPrincipalDTO());
        List lista = this.tituloDummyDAO.buscarTitulosPorLista(tit.getIdLista());
        HashMap<String, Titulo> titulos = new HashMap<String, Titulo>();
        for (Titulo titulo : lista) {
            titulos.put(titulo.getIdBv(), titulo);
        }
        result.getDatosCarga().setTOTAL_REGISTROS(String.valueOf(titulos.size()));
        for (ParamCargaCostosDTO paramCargaCostosDTO : precios) {
            if (Objects.nonNull(titulos.get(paramCargaCostosDTO.getIdBroadView()))) {
                if (!TituloBO.esNumero(paramCargaCostosDTO.getPrecio())) {
                    response.getErroresControlados().add(titulos.get(paramCargaCostosDTO.getIdBroadView()));
                    titulos.remove(paramCargaCostosDTO.getIdBroadView());
                    continue;
                }
                response.getExitos().add(titulos.get(paramCargaCostosDTO.getIdBroadView()));
                titulos.remove(paramCargaCostosDTO.getIdBroadView());
                continue;
            }
            tit = new Titulo();
            tit.setIdBv(paramCargaCostosDTO.getIdBroadView());
            tit.setPrecioAnual(paramCargaCostosDTO.getPrecio());
            response.getErroresNoControlados().add(tit);
        }
        if (titulos.size() != 0) {
            for (Map.Entry entry : titulos.entrySet()) {
                response.getErroresNoControlados().add(entry.getValue());
            }
        }
        if (response.getErroresControlados().isEmpty() && response.getErroresNoControlados().isEmpty()) {
            for (ParamCargaCostosDTO paramCargaCostosDTO : precios) {
                this.tituloDummyDAO.actualizarCostos(paramCargaCostosDTO.getPrecio(), paramCargaCostosDTO.getIdBroadView());
            }
            result.setMensaje("Todos los costos se cargaron con exito.");
        } else {
            result.setMensaje("Existen detalles en el documento.");
        }
        result.getDatosCarga().setTOTAL_CARGADOS(String.valueOf(response.getExitos().size()));
        result.getDatosCarga().setTOTAL_ERROR(String.valueOf(response.getErroresNoControlados().size() + response.getErroresControlados().size()));
        response.setResponse(result);
        return response;
    }

    private static boolean esNumero(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public RespuestaCargaExcel cargaMasivaDeTitulos2(Titulo titulo, ContratoDTO contrato, TipoCargaDocumento tc, File fileUpload, String fileName, Lista listaActual, String expediente) throws TituloException {
        RespuestaCargaExcel r = new RespuestaCargaExcel();
        if (!tc.equals((Object)TipoCargaDocumento.COSTOS)) {
            this.logger.debug("\t");
            Double costo = this.tituloDummyDAO.buscarTotalCostoTitulos(contrato.getIdContrato(), "M");
            costo = costo != null ? costo : 0.0;
            try {
                byte[] f = FileUtils.readFileToByteArray((File)fileUpload);
                File d = new File(this.uriCarga + contrato.getIdContrato() + expediente + fileName);
                d.setExecutable(true, false);
                d.setReadable(true, false);
                d.setWritable(true, false);
                this.logger.debug("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
                FileUtils.writeByteArrayToFile((File)d, (byte[])f);
                this.logger.debug(" RFD 24 02 2020 URI LANZADA [{}]", (Object)this.dlaRestClientFactory.getClient(DLARestServices.CARGA_TITULOS));
                DLARestClient c = this.dlaRestClientFactory.getClient(DLARestServices.CARGA_TITULOS);
                ParamCargaTitulosDTO request = new ParamCargaTitulosDTO();
                request.setNombreArchivo(FilenameUtils.getName((String)d.getCanonicalPath()));
                request.setIdContrato(contrato.getIdContrato().toString());
                request.setIdListaActual(listaActual.getIdLista().toString());
                request.setTipoLista(TipoCargaDocumento.NUEVA.equals((Object)tc) ? "NUEVA" : "ACTUAL");
                request.setTipoCarga(TipoCargaDocumento.ANEXAR.equals((Object)tc) ? "AGREGAR" : "REEMPLAZAR");
                request.setExpediente(expediente);
                Calendar cal = Calendar.getInstance();
                cal.setTime(contrato.getFechaInicio());
                cal.set(2, cal.get(2) - 1);
                cal.set(5, 1);
                SimpleDateFormat fecha = new SimpleDateFormat("dd/MM/yyyy");
                request.setFechaInicioContrato(fecha.format(cal.getTime()));
                this.logger.info("{}", (Object)request.getFechaInicioContrato());
                String sFechaInicio = "";
                Date dFechaInicio = titulo.getFechaInicio();
                this.logger.info("{}", (Object)dFechaInicio);
                if (dFechaInicio != null) {
                    cal.setTime(dFechaInicio);
                    cal.set(1, cal.get(1) + 1);
                    sFechaInicio = fecha.format(cal.getTime());
                }
                this.logger.info("{}", (Object)sFechaInicio);
                this.logger.info("{}", (Object)request.getFechaInicioContrato());
                this.logger.info("{}", (Object)dFechaInicio);
                request.setFechaInicioListaNueva(sFechaInicio);
                this.logger.debug("Request carga titulos [{}]", (Object)request);
                ResponseCargaTitulosDTO response = c.get(request, ResponseCargaTitulosDTO.class);
                this.logger.debug("Response carga titulos [{}]", (Object)response);
                if (!response.isResultado()) {
                    this.logger.debug("Error en el response  [{}]", (Object)response.getMensaje());
                    throw new TituloException(response.getMensaje());
                }
                r.setResponse(response);
                if (!response.getDatosCarga().getTOTAL_ERROR().equals("0")) {
                    this.logger.debug("Inicio Creaci\u00f3n Excel.");
                    List a = new ArrayList();
                    Date d1 = new Date();
                    a = this.tituloErrores.buscarErroresTitulo(Long.valueOf(Long.parseLong(response.getDatosCarga().getID_CARGA())));
                    this.logger.debug("Tiempo de busqueda [{}] total Errors[{}]", (Object)(new Date().getTime() - d1.getTime()), (Object)a.size());
                    d1 = new Date();
                    byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(a, "titulo", Titulo.class);
                    this.logger.debug("Tiempo de transformacion [{}] ", (Object)(new Date().getTime() - d1.getTime()));
                    File destFile = new File(this.uriErrores + contrato.getIdContrato());
                    FileUtils.writeByteArrayToFile((File)destFile, (byte[])fileExcel);
                    d1 = new Date();
                    this.logger.debug("Tiempo de escritura [{}] ", (Object)(new Date().getTime() - d1.getTime()));
                    this.logger.debug("Fin Creaci\u00f3n Excel.");
                }
            }
            catch (ExcelMapperException e) {
                this.logger.error("Errores [{}]", (Object)e.getSErrors());
                this.logger.error("Error al leer el archivo", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.debug("Error ", (Throwable)e);
                throw new TituloException("Ocurrio un error al subir el documento");
            }
            this.logger.debug("Inicio Busqueda.");
            Lista listaA = this.listaDAO.buscarListaActual(contrato.getIdContrato(), "M");
            this.logger.debug("Fin Busqueda.");
            if (!TipoCargaDocumento.ANEXAR.equals((Object)tc)) {
                costo = 0.0;
            }
            this.logger.debug("Inicio Busqueda Costo.");
            Double costoFinal = this.tituloDummyDAO.buscarTotalCostoTitulos(contrato.getIdContrato(), "M");
            costoFinal = costoFinal != null ? costoFinal : 0.0;
            this.logger.debug("Costo anterior [{}] costo final[{}]", (Object)costo, (Object)costoFinal);
            r.setMonto(Double.valueOf(costoFinal - costo));
            r.setLista(listaA);
            return r;
        }
        r = this.actualizarCostos(contrato, fileUpload, fileName, titulo);
        Double costo = this.tituloDummyDAO.buscarTotalCostoTitulos(contrato.getIdContrato(), "M");
        costo = costo != null ? costo : 0.0;
        Double costoFinal = this.tituloDummyDAO.buscarTotalCostoTitulos(contrato.getIdContrato(), "M");
        costoFinal = costoFinal != null ? costoFinal : 0.0;
        this.logger.debug("Costo anterior [{}] costo final[{}]", (Object)costo, (Object)costoFinal);
        r.setMonto(Double.valueOf(costoFinal - costo));
        Lista lista = this.listaDAO.buscarListaActual(contrato.getIdContrato(), "M");
        r.setLista(lista);
        return r;
    }

    public void guardaLoteReal(List<Titulo> titulos) {
        int total = titulos.size();
        int step = 0;
        int end = total / 1000 + 1;
        this.logger.debug("Total [{}]", (Object)total);
        this.logger.debug("End [{}]", (Object)end);
        if (total != 0) {
            do {
                int from;
                int to = (from = step * 1000) + 1000 > total ? from + total % 1000 : from + 1000;
                this.logger.debug(" step[{}] from [{}]   ,  to [{}]", new Object[]{++step, from, to - 1});
                List<Titulo> p = titulos.subList(from, to);
                this.tituloChunkDAO.aReal(p);
            } while (step != end);
        }
    }

    public List<CatalogoDTO> buscaTipoCargaDocumento(ContratoDTO ct) {
        ArrayList<TipoCargaDocumento> r = new ArrayList<TipoCargaDocumento>();
        if (ct.getIdTipoMovimiento().intValue() == 3) {
            Lista lista = this.listaDAO.buscarListaActual(ct.getIdContrato(), "M");
            List titulos = this.tituloDAO.buscarTitulosPorLista(lista.getIdLista());
            this.logger.info("{} {}", (Object)titulos, (Object)titulos.size());
            boolean tIdSap = false;
            for (Titulo titulo : titulos) {
                if (titulo.getIdSap() == null) continue;
                this.logger.info("{}", (Object)titulo);
                tIdSap = true;
                break;
            }
            this.logger.info("{}", (Object)tIdSap);
            this.logger.info("{} {}", (Object)lista.getIdContratoCreacion(), (Object)ct.getIdContrato());
            if (lista.getIdContratoCreacion().equals(ct.getIdContrato())) {
                r.add(TipoCargaDocumento.ANEXAR);
                if (!tIdSap) {
                    r.add(TipoCargaDocumento.REEMPLAZAR);
                }
                this.logger.info("{}", r);
            } else {
                r.add(TipoCargaDocumento.ANEXAR);
            }
        } else {
            r.add(TipoCargaDocumento.ANEXAR);
            r.add(TipoCargaDocumento.REEMPLAZAR);
        }
        r.add(TipoCargaDocumento.COSTOS);
        List l = this.listaDAO.buscarListasPorContratoCreacion(ct.getIdContrato(), "M");
        this.logger.info("{} {}", (Object)l, (Object)l.size());
        if (l.size() == 0) {
            r.add(TipoCargaDocumento.NUEVA);
        }
        ArrayList<CatalogoDTO> tiposCarga = new ArrayList<CatalogoDTO>();
        for (TipoCargaDocumento tipo : r) {
            tiposCarga.add(new CatalogoDTO(tipo.getValue(), tipo.getDesc()));
        }
        return tiposCarga;
    }

    public Date calculaFechaMasUnDia(Date in) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.set(6, cal.get(6) + 1);
        return cal.getTime();
    }

    public void actualizaEstatusTitulo(String estatus, Long idContrato) {
        this.tituloDAO.actualizarEstatusSapTitulo(estatus, idContrato);
    }
}

