/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosExcepciones;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosMinimos;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosPrecio;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosRevenue;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.LibreriaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PrecioRentaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueBoxGloDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeccionesTerminos;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminosLibreria
extends BaseBO {
    @Autowired
    private TerminosMinimos minimos;
    @Autowired
    @Qualifier(value="precioLibreria")
    private TerminosPrecio precio;
    @Autowired
    private TerminosRevenue revenue;
    @Autowired
    private TerminosExcepciones excepciones;

    public LibreriaDTO obtenerLibreria(Long idContrato) throws TransaccionException {
        LibreriaDTO revenueDTO = new LibreriaDTO();
        try {
            MinimoGarantizadoDTO minimo = this.minimos.obtenerMinimos(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            PrecioRentaDTO price = this.precio.obtenerDatosPreciosLibreria(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            ExcepcionesSeccionDTO excepcionesDTO = this.excepciones.obtenerExcepciones(idContrato, SeccionesTerminos.RentaPremium.getDesc());
            RevenueBoxGloDTO revenueDatos = this.revenue.obtenerRevenueLibreria(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            revenueDTO.setMinimos(minimo);
            revenueDTO.setPrecio(price);
            revenueDTO.setExcepciones(excepcionesDTO);
            revenueDTO.setRevenue(revenueDatos);
        }
        catch (Exception e) {
            new TransaccionException("Error al obtener terminos premium.", e);
        }
        return revenueDTO;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarLibreria(LibreriaDTO p, Long idContrato) throws JsonParseException, JsonMappingException, IOException, TransaccionException {
        try {
            this.logger.debug(p.toString());
            this.revenue.eliminarMinimosCategoriasBoxOffice(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            this.revenue.elimnarRevenueGlobal(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            this.precio.eliminarPaisesImpuestoEstatus(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            this.precio.eliminarPreciosLibreria(idContrato);
            this.excepciones.eliminarExcepcion(idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            this.minimos.guardarMinimos(p.getMinimos().getMinimosCateg(), p.getMinimos().getMinimosAnio(), p.getMinimos().getAnios(), p.getMinimos().getTipoMin(), SeccionesTerminos.RentaLibreria.getDesc(), idContrato);
            this.precio.actualizarPrecioAplica(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getPrecio().getAplica());
            this.precio.actualizarPagoPpe(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getPrecio().getPagoPPE());
            if (p.getPrecio().getAplica() == 1) {
                this.precio.guardarDatosPreciosLibreria(p.getPrecio(), idContrato, SeccionesTerminos.RentaLibreria.getDesc());
            }
            this.revenue.guardarRevenueLibreria(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getRevenue());
            this.excepciones.guardarExcepciones(idContrato, SeccionesTerminos.RentaLibreria.getDesc(), p.getExcepciones());
        }
        catch (Exception e) {
            new TransaccionException("Error al obtener terminos premium.", e);
        }
    }
}

