/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosExcepciones;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosMinimos;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosPrecio;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosRevenue;
import com.mx.dla.dda.contrato.transaccion.terminos.daos.TerminosTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PrecioRentaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueBoxGloDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeccionesTerminos;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeriesDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosAuxiliarDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosPaisDTO;
import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminosSerie
extends BaseBO {
    @Autowired
    private TerminosMinimos minimos;
    @Autowired
    private TerminosRevenue revenue;
    @Autowired
    private TerminosTransaccionDAO dao;
    @Autowired
    @Qualifier(value="precioMovies")
    private TerminosPrecio precio;
    private List<TerminosPaisDTO> paises;
    private List<TerminosPaisDTO> categorias;
    private List<TerminosPaisDTO> formatos;
    @Autowired
    private TerminosExcepciones excepciones;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public SeriesDTO obtenerSerie(Long idContrato) throws TransaccionException {
        SeriesDTO movies = new SeriesDTO();
        try {
            MinimoGarantizadoDTO minimo = this.minimos.obtenerMinimos(idContrato, SeccionesTerminos.VentaSeries.getDesc());
            movies = this.obtenerDatosDTOSeries(movies, idContrato, SeccionesTerminos.VentaSeries.getDesc());
            RevenueBoxGloDTO rev = this.revenue.obtenerRevenueSeries(idContrato, SeccionesTerminos.VentaSeries.getDesc(), movies.getPrecio().getPrecio());
            ExcepcionesSeccionDTO excepcionesDTO = this.excepciones.obtenerExcepciones(idContrato, SeccionesTerminos.VentaSeries.getDesc());
            movies.setMinimos(minimo);
            movies.setRevenue(rev);
            movies.setExcepciones(excepcionesDTO);
        }
        catch (Exception e) {
            new TransaccionException("Error al obtener terminos movies.", e);
        }
        return movies;
    }

    public SeriesDTO obtenerDatosDTOSeries(SeriesDTO terminos, Long idContrato, String seccion) {
        this.formatos = this.dao.obtenerFormatos();
        this.categorias = this.dao.obtenerCatSeries();
        Integer aplica = this.dao.obtenerAplicaPrecios(idContrato, seccion);
        Integer pagoPpe = this.dao.obtenerPagoPpe(idContrato, seccion);
        List paises = this.dao.obtenerPaises(idContrato);
        List impuestoEstatus = this.dao.obtenerPaisesImpuestoEstatus(idContrato, seccion);
        for (TerminosPaisDTO pais : paises) {
            if (pais.getAplicaImpuesto() == null) {
                pais.setAplicaImpuesto(Integer.valueOf(0));
            }
            for (TerminosPaisDTO impuesto : impuestoEstatus) {
                if (!pais.getIdPais().equals(impuesto.getIdPais())) continue;
                pais.setAplicaImpuesto(impuesto.getAplicaImpuesto());
            }
        }
        this.paises = paises;
        PrecioRentaDTO price = new PrecioRentaDTO();
        String[][] datos = (String[][])ListaUtilerias.safeArray((Object[][])null, String.class, (int)1, (int)(paises.size() * 2 + 2));
        String[] formatosS = new String[this.formatos.size()];
        for (int i = 0; i < this.formatos.size(); ++i) {
            formatosS[i] = this.formatos.get(i).getDescripcion();
        }
        String[] categoriasS = new String[this.categorias.size()];
        for (int i = 0; i < this.categorias.size(); ++i) {
            categoriasS[i] = this.categorias.get(i).getDescripcion();
        }
        List precios = this.dao.obtenerPrecioSeries(idContrato);
        if (precios != null && !precios.isEmpty()) {
            datos = this.precio.obtenerDatosPrecioMovSer(formatosS, this.paises, categoriasS, null, precios);
        }
        price.setPrecio(datos);
        price.setAplica(Integer.valueOf(aplica == null ? 1 : aplica));
        price.setPagoPPE(Integer.valueOf(pagoPpe == null ? 0 : pagoPpe));
        price.setPaises(this.paises);
        terminos.setPrecio(price);
        terminos.setCategorias(categoriasS);
        return terminos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarSerie(SeriesDTO p, Long idContrato) throws JsonParseException, JsonMappingException, IOException, TransaccionException {
        try {
            this.logger.debug(p.toString());
            this.revenue.eliminarRevenueBoxSeries(idContrato);
            this.revenue.elimnarRevenueGlobal(idContrato, SeccionesTerminos.VentaSeries.getDesc());
            this.precio.eliminarPaisesImpuestoEstatus(idContrato, SeccionesTerminos.VentaSeries.getDesc());
            this.precio.eliminarPreciosSeries(idContrato);
            this.excepciones.eliminarExcepcion(idContrato, SeccionesTerminos.VentaSeries.getDesc());
            this.minimos.guardarMinimos(p.getMinimos().getMinimosCateg(), p.getMinimos().getMinimosAnio(), p.getMinimos().getAnios(), p.getMinimos().getTipoMin(), SeccionesTerminos.VentaSeries.getDesc(), idContrato);
            this.precio.actualizarPrecioAplica(idContrato, SeccionesTerminos.VentaSeries.getDesc(), p.getPrecio().getAplica());
            this.precio.actualizarPagoPpe(idContrato, SeccionesTerminos.VentaSeries.getDesc(), p.getPrecio().getPagoPPE());
            boolean aplicaPrecio = p.getPrecio().getAplica() == 1;
            boolean isGlobalRevenue = p.getRevenue().isRevenueGlobal();
            boolean isBoxOfficeRevenue = p.getRevenue().isRevenueBox();
            if (aplicaPrecio) {
                this.guardarDatosPreciosSeries(p.getPrecio(), idContrato, this.categorias, this.formatos, this.paises, SeccionesTerminos.VentaSeries.getDesc());
            }
            Long[] categoriasS = new Long[this.categorias.size()];
            for (int i = 0; i < this.categorias.size(); ++i) {
                categoriasS[i] = this.categorias.get(i).getIdPais();
            }
            if (isBoxOfficeRevenue && aplicaPrecio || isGlobalRevenue) {
                this.revenue.guardarRevenueSeries(idContrato, SeccionesTerminos.VentaSeries.getDesc(), this.categorias, p.getRevenue());
            }
            this.excepciones.guardarExcepciones(idContrato, SeccionesTerminos.VentaSeries.getDesc(), p.getExcepciones());
        }
        catch (Exception e) {
            new TransaccionException("Error al obtener terminos premium.", e);
        }
    }

    public void guardarDatosPreciosSeries(PrecioRentaDTO precioSeries, Long idContrato, List<TerminosPaisDTO> categorias, List<TerminosPaisDTO> formatos, List<TerminosPaisDTO> paises, String seccion) throws TransaccionException {
        try {
            List<Object> precios = new ArrayList();
            String[][] datos = precioSeries.getPrecio();
            Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
            precios = this.precio.generarDatosMoviesSeries(datos, idContrato, categorias, formatos, paises);
            this.dao.guardarValoresPrecioSeries(precios, idContrato);
            for (TerminosPaisDTO pais : precioSeries.getPaises()) {
                TerminosAuxiliarDTO impuesto = new TerminosAuxiliarDTO();
                impuesto.setIdOpcionalA(idContrato);
                impuesto.setIdOpcionalB(pais.getIdPais());
                impuesto.setIdOpcionalC(idSeccion);
                impuesto.setValorA(pais.getAplicaImpuesto());
                this.dao.guardaPaisesImpuestoEstatus(impuesto);
            }
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al guardar los datos.", e);
        }
    }
}

