/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.movimientos.bos;

import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.reporte.movimientos.daos.ReporteMovimientosDAO;
import com.mx.dla.dda.reporte.movimientos.dtos.ReporteMovimietosDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReporteMovimientosBO
extends BaseBO {
    @Autowired
    private ReporteMovimientosDAO reporteMovimientos;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private ExcelMapperContext excelMapperContext;

    public List<ReporteMovimietosDTO> obtenerDatosReporte(String contrato, String estudio, String mes) {
        List reporte = this.reporteMovimientos.obtenerReporteMovimientos(contrato, estudio, mes);
        for (ReporteMovimietosDTO data : reporte) {
            data.setMovimiento("");
            if (!data.getBaja().equals("NO")) {
                data.setMovimiento(data.getBaja());
            }
            if (!data.getCambioCosto().equals("NO")) {
                data.setMovimiento(data.getCambioCosto());
            }
            if (!data.getVidaUtil().equals("NO")) {
                data.setMovimiento(data.getVidaUtil());
            }
            if (!data.getMovimiento().isEmpty()) continue;
            data.setMovimiento("ALTA");
        }
        return reporte;
    }

    public InputStream obtenerReporteEnExcel(String contrato, String estudio, String mes) {
        byte[] info = null;
        ByteArrayInputStream reporte = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("reporteMovimientos");
        this.logger.info("{}", (Object)mapper);
        String[] encabezado = new String[]{"ID BV", "ACTIVO", "MOVIMIENTO", "FECHA NOTIF SAP", "CODIGO DDA", "DESC TITULO", "CONTRATO DDA", "FECHA INICIO", "FECHA FIN", "COSTO", "FECHA CONTABILIZACION"};
        List<ReporteMovimietosDTO> reporteInfo = null;
        try {
            for (int i = 0; i < encabezado.length; ++i) {
                String s = String.format(((ExcelRule)mapper.getRules().get(i)).getHeader(), encabezado[i]);
                ((ExcelRule)mapper.getRules().get(i)).setHeader(s);
            }
            reporteInfo = this.obtenerDatosReporte(contrato, estudio, mes);
            this.logger.info("{}", (Object)mapper);
            info = this.excelMapperTransform.transformObjectToExcel(reporteInfo, mapper, ReporteMovimietosDTO.class);
            reporte = new ByteArrayInputStream(info);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return reporte;
    }
}

