package com.mx.dla.dda.contrato.listado.dtos;

public enum ContentType {

	PDF(   "pdf",  "application/pdf"), 
	WORD(  "doc",  "application/msword"), 
	EXCEL( "xls",  "application/vnd.ms-excel"), 
	POINT( "ppt",  "application/vnd-ms-powerpoint"),
	WORDX( "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"), 
	EXCELX("xls",  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=iso-8859-1"), 
	POINTX("ppt",  "application/vnd.openxmlformats-officedocument.presentationml.presentarion"),
	PNG(   "png",  "image/png"), 
	JPG(   "jpg",  "image/jpeg"),
	BMP(   "bmp",  "image/bmp"),
	ZIP(   "zip",  "application/zip"),
	TXT(   "txt",  "text/plain");
		
	private String typeFile;
	private String type;

	ContentType(String file, String type){
		this.type = type;
		this.typeFile = file;
	}
	
	public static String getType(String typeFile){
	
		ContentType [] items = ContentType.values();
		String result = null;
		
		for(ContentType c : items)
		{
			 if(c.typeFile.compareTo(typeFile) == 0)
			 {
				 result = c.type;
				 break;
			 }
		}
		return result;		  
	}
}
