package com.mx.dla.dda.contrato.transaccion.terminos.actions;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosMovie;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosSerie;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosTransaccionBO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MoviesDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeriesDTO;
import com.opensymphony.xwork2.Action;

public class TerminosSeriesAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	@Autowired
	private TerminosSerie service;
	
	@Autowired
	private TerminosTransaccionBO comun;
	
	private SeriesDTO series;	
	private String mensaje;
	private String error;
	private Long idContrato;
	
	public String obtener(){
		try 
		{			
			series = service.obtenerSerie((Long)this.getSession().get("idContrato"));
						
		}catch (TransaccionException e) {
			error = e.getMessage();
		}		
		return Action.SUCCESS;
	}
	
	public String guardar(){
		try 
		{			
			logger.debug("par {}", series.toString());
			comun.guardarDatosComun(series.getComun(), this.idContrato);
			service.guardarSerie(series,this.idContrato);
			comun.calculaPagoMinGarantizado(this.idContrato);

			
		}catch (TransaccionException e) {
			error = e.getMessage();				
		}catch (Exception e) {
			error = "Error al guardar los Terminos Premium";
			logger.error("Error {}",e);
		}		
		return Action.SUCCESS;
	}

	
	public String     getMensaje()     { return mensaje; }
	public String     getError()       { return error; }
	public SeriesDTO getSeries()       { return series; }

	public void setSeries(SeriesDTO series)    { this.series = series; }
	public void setIdContrato(Long idContrato) { this.idContrato = idContrato; }
	
}