package com.mx.dla.dda.contrato.transaccion.titulos.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCargaDocumento;
import com.mx.dla.dda.contrato.titulo.dtos.RespuestaCargaExcel;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranBO;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranGridBO;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.opensymphony.xwork2.Action;

public class TituloTransAction extends BaseContratoAction {

	private static final long serialVersionUID = -2801098338739181070L;
	
	@Autowired
	private GeneralesBO generalesBO;
	
	@Autowired
	private TituloTranBO tituloBO;
	
	@Autowired
	private TituloTranGridBO tituloTranGridBO;
	
	private List<CatalogoDTO> filiales;
	private List<CatalogoDTO> categorias;
	private List<CatalogoDTO> generosA;
	private List<CatalogoDTO> generosB;
	private List<CatalogoDTO> tiers;
	private List<CatalogoDTO> catSeries;
	private List<CatalogoDTO> listas;
	private List<TipoCargaDocumento> tipoCargas;
	private List<Long>        listasValidas;
	private String            error;
	private Long              idLista;
	private Integer           numTitulos;
		
	private String            inicioLista;
	private String            fileFileName;
	private InputStream       fileInputStream;
	private File              file;
	private String            tipoCarga;
	private RespuestaCargaExcel respuestaExcel;	
	
	public String execute() throws Exception {		
		ContratoDTO cto = this.inicializarContrato();				
		tituloBO.init(cto.getIdContrato(), cto.getFechaInicio(), false);
		this.tipoCargas = tituloBO.buscaTipoCargaDocumento(cto.getIdContrato());
		this.getServletRequest().setAttribute("tipoCargas", this.tipoCargas);
		return SUCCESS;
	}
	
	public String obtenerDatosInicio(){
		try
		{
			Long idContrato = (Long)this.getSession().get("idContrato");				
			this.inicializarCatalogos(idContrato);						
			this.idLista    = tituloBO.buscarListaActual(idContrato, "M").getIdLista();
			this.listas     = tituloBO.buscaListas(idContrato);
			this.numTitulos = tituloBO.buscarNumTitulosContratados(idContrato);
		
		}catch(Exception e )
		{
			logger.error("Error : {}",e);
			error = "Ocurrio un error con la operacion";
		}
		return Action.SUCCESS;	
	}
		
	public String guardarCambiosPermanente() {
		try
		{
			Long idContrato = (Long)this.getSession().get("idContrato");
			tituloBO.guardarCambiosPermanente(idContrato);
			//System.out.println("IdContrato a notificar: "+idContrato);
		}
		catch(Exception e )
		{
			logger.error("Error. guardarCambiosPermanente : ",e);
			error = "Ocurrio un error con la operacion";
		}
		return SUCCESS;
	}
	
	public String descargar() throws ExcelMapperException, IOException { 
		try
		{			
			byte [] bytes   = tituloBO.generateExcelReport(this.idLista);
			fileInputStream = new ByteArrayInputStream(bytes);						
			fileFileName    = tituloBO.generaNombreDescarga();
			return SUCCESS;
		}
		catch(Exception e)
		{
			logger.error("Error ",e);
			error="Ocurrio un error al descargar el documento";
			return ERROR;
		}
	}
	
	//jun-17
	public String cargaMasiva() throws ExcelMapperException, IOException {
		try
		{
			Date i = new Date();
			Long idContrato    = (Long)this.getSession().get("idContrato");			
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");			
						
			logger.debug("tipo {}", tipoCarga);
			logger.debug("inicioLista {}", inicioLista);
			logger.debug("fileFileName {}", fileFileName);
			
			respuestaExcel = tituloBO.cargaMasivaTitulos(this.inicioLista, idContrato, this.tipoCarga, this.file, this.fileFileName, this.idLista, usuario.getExpediente());			
						
			logger.debug("Tiempo  titulosBO.cargaMasivaDeTitulos  [{}]", new Date().getTime() - i.getTime() );
		}
		catch(TituloException e )
		{
			logger.error("Error ",e);
			error = e.getMessage();
		}
		catch(Exception e)
		{
			logger.error("Error ",e);
			error="Ocurrio un error al subir el documento";
		}
		return SUCCESS;
	}
	
	public String buscarListas(){
		try
		{			
			Long idContrato = (Long)this.getSession().get("idContrato");			
			this.listas     = tituloBO.buscaListas(idContrato);		   												
		}
		catch(Exception e)
		{
			logger.error("Error ",e);
			error="Ocurrio un error al subir el documento";
		}
		return SUCCESS;
	}
	
	public String descarArchivoErrores() throws ExcelMapperException, IOException {
		try
		{
			Long idContrato = (Long)this.getSession().get("idContrato");
			
			byte [] bytes = tituloBO.buscarArchivoDeErrores(idContrato);						
			fileInputStream = new ByteArrayInputStream(bytes);
			
			Date a = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
			fileFileName = "errores-"+sdf.format(a)+".xlsx";
			logger.debug("Saco el nombre",fileFileName);
			return SUCCESS;
		}
		catch(Exception e)
		{
			logger.error("Error ",e);
			error="No existe documento de errores";
			return ERROR;
		}
	}		
		
	private ContratoDTO inicializarContrato(){
		this.setIdContrato((Long)this.getSession().get("idContrato"));		
		ContratoDTO ct = generalesBO.obtenContrato(this.getIdContrato());						
		setEstatusContrato(ct.getIdEstatus());
		return ct;
	}
	
	private void inicializarCatalogos(Long idContrato){
		tituloTranGridBO.obtenerCatalogos(idContrato);
		this.filiales  = tituloTranGridBO.getFiliales();
		this.categorias= tituloTranGridBO.getCategorias();
		this.generosA  = tituloTranGridBO.getGenerosA();
		this.generosB  = tituloTranGridBO.getGenerosB(); 
		this.tiers     = tituloTranGridBO.getTiers();
		this.catSeries = tituloTranGridBO.getCatSeries();
		this.listasValidas = tituloBO.buscaListasValidas(idContrato);
	}

	public List<CatalogoDTO> getFiliales()   { return filiales; }	
	public List<CatalogoDTO> getCategorias() { return categorias; }
	public List<CatalogoDTO> getGenerosA()   { return generosA;}
	public List<CatalogoDTO> getGenerosB()   { return generosB;}
	public List<CatalogoDTO> getTiers()      { return tiers;}	
	public List<CatalogoDTO> getCatSeries()  { return catSeries;}	
	public List<TipoCargaDocumento> getTipoCargas() {return tipoCargas; }
	public String            getError()      { return error; }
	public List<CatalogoDTO> getListas()     { return listas; }
	public Long              getIdLista()    { return idLista; }
	public String            getFileFileName()     { return fileFileName; }
	public InputStream       getFileInputStream()  { return fileInputStream; }
	public RespuestaCargaExcel getRespuestaExcel() { return respuestaExcel; }		
	public Integer getNumTitulos()                 { return numTitulos; }
	public List<Long> getListasValidas()     { return listasValidas; }

	public void setIdLista(Long idLista) { this.idLista = idLista; }
	public void setFileFileName(String fileFileName) { this.fileFileName = fileFileName; }
	public void setFileInputStream(InputStream fileInputStream) { this.fileInputStream = fileInputStream; }
	public void setFile(File file) { this.file = file; }
	public void setTipoCarga(String tipoCarga) { this.tipoCarga = tipoCarga; }
	public void setInicioLista(String inicioLista) { this.inicioLista = inicioLista; }		
}