package com.mx.dla.dda.reporte.oyp.actions;

import java.io.InputStream;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.oyp.bos.ReporteOveragesYPaymentsBO;
import com.mx.dla.dda.reporte.oyp.dtos.ReporteOveragesYPaymentsVistaDTO;

public class ReporteOveragesYPaymentsViewAction extends BaseContratoAction {

	private static final long				 serialVersionUID = -8363640992586901052L;
	private String							 fechaInicial;
	private String							 fechaFinal;
	private String							 tipoPago;
	private ReporteOveragesYPaymentsVistaDTO reporteVista;
	private InputStream						 fileInputStream;
	private Long							 idEstudio;
	private String							 claveReporte;
	private List<EstudioDTO>				 estudios;
	private String                           validaEstatusCarga;

	/*
	 * private String fileName; private String tipoReporte; private File file;
	 * private String fileFileName;
	 */
	private String							 errorMensaje;

	@Autowired
	private ReporteOveragesYPaymentsBO		 reporteOveragesYPaymentsBO;

	public String obtenerDatosReporte() {

		try {

			logger.info("fechaInicial: {}", fechaInicial);
			logger.info("fechaFinal: {}", fechaFinal);
			logger.info("tipoPago: {}", tipoPago);
			logger.info("claveReporte: {}", claveReporte);
			logger.info("idEstudio: {}", idEstudio);
			logger.info("validaEstatusCarga: {}", validaEstatusCarga);

			reporteVista = reporteOveragesYPaymentsBO.obtenerReporteOveragesYPaymentsVista(fechaInicial, fechaFinal, tipoPago, claveReporte, idEstudio, validaEstatusCarga);

			logger.info("getTabla: {}", reporteVista.getTabla());
			// logger.info("getPheader: {}", reporteVista.getPheader());
			// logger.info("getRheader: {}", reporteVista.getRheader());

		}
		catch (Exception e) {
			errorMensaje = e.getMessage();
		}

		return SUCCESS;
	}

	public String obtenerEstudios() {

		try {
			estudios = reporteOveragesYPaymentsBO.obtenerEstudios();
			logger.info("estudios: {}", estudios);
		}
		catch (Exception e) {
			errorMensaje = e.getMessage();
		}

		return SUCCESS;
	}

	public String exportarReporte() {
		try {

			logger.info("fechaInicial: {}", fechaInicial);
			logger.info("fechaFinal: {}", fechaFinal);
			logger.info("tipoPago: {}", tipoPago);
			logger.info("claveReporte: {}", claveReporte);
			logger.info("idEstudio: {}", idEstudio);
			logger.info("validaEstatusCarga: {}", validaEstatusCarga);

            UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			fileInputStream = reporteOveragesYPaymentsBO.obtenerStreamReporte(fechaInicial, fechaFinal, tipoPago, claveReporte, idEstudio, usuario.getExpediente(), validaEstatusCarga);
			// fileName = "nombreTest";
		}
		catch (Exception e) {
			errorMensaje = e.getMessage();
		}
		return SUCCESS;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public String getErrorMensaje() {
		return errorMensaje;
	}

	public void setErrorMensaje(String errorMensaje) {
		this.errorMensaje = errorMensaje;
	}

	public String getFechaInicial() {
		return fechaInicial;
	}

	public void setFechaInicial(String fechaInicial) {
		this.fechaInicial = fechaInicial;
	}

	public String getFechaFinal() {
		return fechaFinal;
	}

	public void setFechaFinal(String fechaFinal) {
		this.fechaFinal = fechaFinal;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public ReporteOveragesYPaymentsVistaDTO getReporteVista() {
		return reporteVista;
	}

	public void setReporteVista(ReporteOveragesYPaymentsVistaDTO reporteVista) {
		this.reporteVista = reporteVista;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public String getClaveReporte() {
		return claveReporte;
	}

	public void setClaveReporte(String claveReporte) {
		this.claveReporte = claveReporte;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public String getValidaEstatusCarga() {
		return validaEstatusCarga;
	}

	public void setValidaEstatusCarga(String validaEstatusCarga) {
		this.validaEstatusCarga = validaEstatusCarga;
	}
	
	

}
