package com.mx.dla.dda.reporte.pago.actions;

import java.io.InputStream;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReporteContingenciaBO;

import lombok.Data;

@Data
public class ReporteContingenciaExcelAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	private String idCon;
	private Long idEstudio;
	private Date fechaInicio;

	@Autowired
	private ReporteContingenciaBO reporteContingenciaBO;
	@Autowired
	private CargaTransaccionesBO bdsp;
	
	public String execute() {
		//System.out.print("Action Excel ...1");

		fileInputStream = reporteContingenciaBO.obtenerReporteEnExcel(idCon, idEstudio);
		//System.out.print("Action Excel ...2");
		
		setFileName( idCon != null ? idEstudio + "_" + idCon : idEstudio + "");
		/*try {
			bdsp.ejecutaSP_MarcaCont(idCon, idEstudio.toString());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}*/
		return SUCCESS;
	}

}
