/**
 *  Archivo que contiene las validaciones para fees 
 */
//c1 : Se valida que los rangos se hayan registrado
//c2 : Se valida los  rangos se hayan regisrado de forma continua rango1 = 1-2, rango2= ""-"", rango3=2-3
//c3 : Se valida que no se empalme los rangos
//c4 : Se valida la longitud sea <= 6
//c5 : Se valida que los registros exsitentes sean numeros
//c6 : Se valida que los rangos se registros completo rangoN: ""-2
function validaRangosSuscritor(rangos){	
	var resultado = {validacion : true, mensaje: "", index: 0};
	var contador  = 0;
	var anterior         = true;
	var rangosCompletos  = true;
	var contadorCompleto = 0;
	var valorRango       = 0;		
		
	for(var i=0; i< rangos.length; i++)
	{		
		if(rangos[i].desde != "" && rangos[i].hasta != "" && anterior)
			contadorCompleto++;
		if(rangos[i].desde == "" && rangos[i].hasta == "" && rangosCompletos)
			contador++;
		if((rangos[i].desde != "" && rangos[i].hasta == "") || (rangos[i].desde == "" && rangos[i].hasta != ""))
			rangosCompletos = false;
		if(rangos[i].desde == "" && rangos[i].hasta == "")
			anterior = false;
		if(rangos[i].desde != "" && rangos[i].hasta != "" && !anterior)
		{
			resultado.validacion = false;
			resultado.mensaje = "Los rangos no son v\u00E1lidos. No se puede dejar un rango intermedio sin llenar.";
		}							
	}
	
	resultado.index = contadorCompleto;
	if(contador == rangos.length && rangosCompletos){
		resultado.validacion = false;
		resultado.mensaje = "Los rangos no son v\u00E1lidos. No se ha registrado un rango.";
	}
	if(!rangosCompletos){
		resultado.validacion = false;
		resultado.mensaje = "Los rangos no son v\u00E1lidos. Verificar rangos completos.";
	}		
		
	if(resultado.validacion)
	{
		for(var i=0; i< contadorCompleto; i++)
		{	
			var desde = rangos[i].desde;
			var hasta = rangos[i].hasta;
			if(!validaNumero(desde) || !validaNumero(hasta) )
			{
				resultado.mensaje = "Los rangos deben ser num\u00E9ricos.";
				resultado.validacion = false;
			    break;
			}						
			if(desde.length > 9 || hasta.length > 9)
			{
				resultado.mensaje = "La longitud m\u00E1xima de los rangos es de 9 caracteres.";
				resultado.validacion = false;
			    break;
			}
			if(resultado.validacion) //si las validaciones son exitosas se convierten en numeros los rangos para seguir validando
			{
				desde = parseInt(rangos[i].desde);
				hasta = parseInt(rangos[i].hasta);
			}			
			if(desde <= 0 || hasta <=0 )
			{
				resultado.mensaje = "Los valores de los rangos no deben ser menores a 0.";
				resultado.validacion = false;
			    break;
			}
			if( desde > hasta )
			{
				resultado.mensaje = "Los valores 'desde' de un rango no pueden ser mayor a los valores 'hasta' del rango.";
				resultado.validacion = false;
			    break;
			}
			
			if( (valorRango <  desde) && ( desde < hasta) ) 
			{
				   valorRango = hasta;
			}
			else{
					resultado.validacion = false;
					resultado.mensaje = "Los rangos no se deben empalmar.";
					break;
			}			
			
			if(rangos[i+1] != null && rangos[i+1].desde != null && rangos[i+1].desde != "")
			{				
				var desdeAux = parseInt(rangos[i+1].desde);
				var hastaAux = parseInt(rangos[i].hasta);
				if( desdeAux-hastaAux != 1 ) 
				{
					resultado.validacion = false;
					resultado.mensaje = "Los rangos no son secuenciales.";
					break;
				}
			}			
		}
	}
	return resultado;
}

//c1 : Se valida se haya registrado una descripcion 
//c2 : Se valida que si existe categoria los rangos validos tengan valores
//c3 : Se valida la longitud sea <= 12
//c4 : Se valida que los registros exsitentes sean numeros
function validaCategoriaSuscriptor(categoria){	
	var resultado = {validacion : true, mensaje: ""};
	if(categoria.descCategoria != "")
	{	
		if(categoria.descCategoria.length > 100)
			resultado.mensaje = "El categor\u00E9a debe ser menor a 100 caracteres.";
		else
		{				
			for(var i=0; i< categoria.rangos.length; i++ )
			{			
				if(categoria.rangos[i].monto == "")
					resultado.mensaje = "El valor de la escala no debe ser nulo.";
	            else if(!validaNumero(categoria.rangos[i].monto))
					resultado.mensaje = "El valor de la escala debe ser num\u00E9rico.";
				else if(categoria.rangos[i].monto.length > 12)
					resultado.mensaje = "El valor de la escala debe ser menos a 12 caracteres.";			
			}
		}		
						
		if(resultado.mensaje != "")
			resultado.validacion =  false;
	}
	else{
		resultado.validacion =  false;	
		resultado.mensaje = "Falta definir Categor\u00EDa."
	}			
	return resultado;
}

//c1 : Se valida que la fecha inicio no se mayor a la fecha fin del periodo 
//c2 : Se valida que el periodo de tiempo este dentro del periodo del contrato
//c3 : Se valida que las fechas se hayan registrado.
function validaPeriodoSuscriptor(periodo){		  
	  var resultado = {validacion : true, mensaje: ""};	  
	  if( periodo.fechaInicio == "" ||  periodo.fechaFin == "")
		  resultado.mensaje = "Las fechas del periodo no se han seleccionado.";
	  
	  else if( !validarFecha(periodo.fechaInicio) || !validarFecha(periodo.fechaFin)) 
		  resultado.mensaje = "Las fechas del periodo no tienen el formato correcto.";
	  
	  else if( $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaInicio).getTime() >= 
	      $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaFin).getTime())
		  resultado.mensaje = "La fecha inicial es mayor o igual a la final.";
				
	  else if( ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaCtoInicio").val()).getTime() > $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaInicio).getTime()) ||  	    
	  	       ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaCtoFin").val()).getTime()    < $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaFin).getTime()) )
      		 resultado.mensaje = "El rango de fecha del periodo no est\u00E1 en el rango de tiempo del contrato.";
	  
	  if( periodo.idSuscriptor != null && resultado.mensaje == "")
	  {
		  if( periodo.idSuscriptor == "0")
			  resultado.mensaje = "No se ha seleccionado el Tipo de Suscriptor.";
	  }
	  
	  if(isNaN(periodo.anioContrato) )	 		  			  
		  resultado.mensaje = "Verifica el campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos entre 0 y 100.";
	  
	  else if(parseInt(periodo.anioContrato) >= 100 || parseInt(periodo.anioContrato) <= 0)
		  resultado.mensaje = "Verifica el campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos entre 0 y 100.";
		  
	  if(resultado.mensaje != "")
		resultado.validacion = false;
	return resultado;
}

function validaPeriodoFlat(periodo){		  
	  var resultado = {validacion : true, mensaje: ""};	  
	
	  if( periodo.fechaInicio == "" ||  periodo.fechaFin == "")
		  resultado.mensaje = "Las fechas del periodo no se han seleccionado.";
	  
	  else if( !validarFecha(periodo.fechaInicio) || !validarFecha(periodo.fechaFin)) 
		  resultado.mensaje = "Las fechas del periodo no tienen el formato correcto.";
	  
	  else if( $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaInicio).getTime() >= 
	      $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaFin).getTime())
		  resultado.mensaje = "La fecha inicial es mayor o igual a la final.";
				
	  else if( ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaCtoInicio").val()).getTime() > $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaInicio).getTime()) ||  	    
	  	       ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaCtoFin").val()).getTime()    < $.datepicker.parseDate( 'mm/dd/yy',  periodo.fechaFin).getTime()) )
    		 resultado.mensaje = "El rango de fecha del periodo no est\u00E1 en el rango de tiempo del contrato."; 
	  	  
	  if( periodo.tipoAnio != null && resultado.mensaje == "")
	  {
		  if( periodo.tipoAnio == "0")
			  resultado.mensaje = "No se ha seleccionado el A\u00F1o de Vida.";
	  }
	  
	  if(resultado.mensaje != "")
		resultado.validacion = false;
	 return resultado;				  	 
}

//c1 : Se valida se haya registrado una descripcion 
//c2 : Se valida la longitud sea <= 12
//c3 : Se valida que los registros exsitentes sean numeros
//c4 : Se valida que si existen registros de montos si existe el registro de la categoria
function validarCategoriaFlat(categoria, fila){	
	var resultado = {validacion : true, mensaje: ""};			
	var contador = 0;
	for(var i=0; i < categoria.anios.length; i++)
	{
		if(categoria.anios[i].costo === "")
		   contador++;
		else
		{
			if(categoria.anios[i].costo.length > 12)
				resultado.mensaje = "El valor del monto debe ser menos a 12 d\u00E9gitos.";
			if(!validaNumero(categoria.anios[i].costo))
				resultado.mensaje = "El valor del monto debe ser num\u00E9rico entero.";
		}
	}	
	if(categoria.descCategoria == "" && (contador == categoria.anios.length) && fila == 0)
		resultado.mensaje = "No se ha registrado ning\u00FAn dato."
	if(categoria.descCategoria == "" && (contador != categoria.anios.length))
		resultado.mensaje = "La categor\u00CDa no debe ser nula."    
	else if(categoria.idcategoria != "" && (contador == categoria.anios.length))
		resultado.mensaje = "La categor\u00CDa no tiene ning\u00FAn monto registrado."
	else if(categoria.descCategoria.length > 100)
		resultado.mensaje = "El categor\u00E9a debe ser menor a 100 caracteres.";
	if(resultado.mensaje  != "")
		resultado.validacion = false;
	return resultado;
}

//c1 : Se valida que los rangos y el bono se han numericos
//c2 : Se valida la longitud del rango sea <= 6 y que el bono sea menor a 12
//c3 : Se valida que los rangos esten completos
//c4 : Se valida que exista un valor del bono para el rango
//c5 : Se valida que exista un rango si existe un valor del bono
function validaRangosBono(rango){		
	var resultado = {validacion : true, mensaje: "", index: 0};
	
	if( rango.desde == "" && rango.hasta == "" && rango.bono == "")
		resultado.mensaje = "Los valores de bono no deben ser nulos.";
	else if((rango.desde != "" && rango.hasta == "") || (rango.desde == "" && rango.hasta != ""))
		resultado.mensaje = "Los rangos no son v\u00E1lidos. Rango incompleto.";
	
	else if(rango.desde != "" && rango.hasta != "" && rango.bono == "")
		resultado.mensaje = "El monto del bono no debe ser nulo.";
	
	else if(rango.desde == "" && rango.hasta == "" && rango.bono != "")
		resultado.mensaje = "El rango no se ha definido para el monto.";
		
	else if(!validaNumero(rango.desde) || !validaNumero(rango.hasta) || !validaNumero(rango.bono))		
		resultado.mensaje = "El rango y bono deben ser num\u00E9ricos enteros.";
	
	else if(rango.desde.length > 12 || rango.hasta.length > 12)		
		resultado.mensaje = "La longitud del rango no debe ser mayor a 12 caracteres.";
	
	else if(rango.bono.length > 12)		
		resultado.mensaje = "La longitud del bono no debe ser mayor a 12 caracteres.";
	
	else if(rango.tipoPago == "0")		
		resultado.mensaje = "Se debe seleccionar el tipo de pago para el rango.";
	else if((rango.desde - rango.hasta) == 0)
		   resultado.mensaje = "Los valores 'desde' y 'hasta' son iguales.";
	else if((rango.hasta - rango.desde)  < 0)
		   resultado.mensaje = "El valor 'desde' no puede ser mayor al valor de 'hasta'.";
	
	if(resultado.mensaje  != "")
		resultado.validacion = false;
	return resultado;
}

//c1 : Se valida que los rangos sean consecutivos
function validaRangosBonoConsecutivos(bono){		
	var resultado = {validacion : true, mensaje: "", index: 0};
	console.log(bono)
	var hasta = bono.rangos[0].hasta;
	for(var i=1; i<bono.rangos.length; i++)
	{				
		if(resultado.validacion && (bono.rangos[i].desde - hasta) != 1)
		{
			resultado.validacion = false;
			resultado.mensaje = "Los rangos deben ser consecutivos.";
		}							
		hasta = bono.rangos[i].hasta;
	}		
	return resultado;
}

function validarAnioFlat(anio){
	anio      = parseInt(anio);
	var anios = (parseInt($("#fechaCtoFin").val().split("/")[2]) - parseInt($("#fechaCtoInicio").val().split("/")[2])) + 1;
	if(anio > 0 && anio <= anios)
	   return true;
	else
	   return false;
}

//c1 : Se valida que las categorias sean diferentes 
function validarCategoriasFees(categorias){	
	var resultado = {validacion : true, mensaje: ""};			
	var contador = 0;
	
	for(var i=0; i <= (categorias.length-1); i++)	
		for(var j=(i+1); j < categorias.length; j++)		
			if(categorias[i].descCategoria === categorias[j].descCategoria)
				contador++;

	if(contador != 0)
	{
		resultado.validacion = false;
		resultado.mensaje    = "No debe existir categor\u00EDas repetidas.";
	}		
	return resultado;
}

//c1 : Se valida que sea nuemerico
//c2 : Se valida que este entre el rango de 0 a 99
function validaPorcentaje(valor){
	var resultado = {validacion : true, mensaje: ""};
	
	if( !validaNumero(valor) && valor != "") 						
		resultado.mensaje = "Porcentaje de Inflaci\u00F3n deber ser num\u00E9rico entero y positivo.";
	
	else if( parseInt(valor) <= 0 || parseInt(valor) > parseInt(99))
		resultado.mensaje = "Porcentaje de Inflaci\u00F3n debe ser mayor a 0 y menor a 99.";
		
	if(resultado.mensaje  != "")
		resultado.validacion = false;
	return resultado;
}

//se valida que la tabla tenga datos
function isNumber(n) {
	  return !isNaN(parseFloat(n)) && isFinite(n);
}

function validarFecha(fecha){
	var validacion = true;
	try {
        $.datepicker.parseDate('mm/dd/yy', fecha);
    } catch (e) {
    	validacion = false;
    };
    return validacion;
}

//c1 : Se valida que el rango de fechas de cada periodo se excluyente entre ellos. 
function validarFechasPeriodos(periodos){
	var resultado = {validacion : true, mensaje: ""};
	
	for(i=1; i<periodos.length;i++){
	     //recorreremos todos los elementos hasta n-i, tomar en cuenta los ultimos no tiene caso ya que ya estan acomodados.
	     for(j=0;j<(periodos.length-i);j++){
	
	          //comparamos	    	 
	          if($.datepicker.parseDate('mm/dd/yy',periodos[j].fechaInicio).getTime() > 
	             $.datepicker.parseDate('mm/dd/yy',periodos[j+1].fechaInicio).getTime()){
	                //guardamos el numero mayor en el auxiliar
	                var aux = periodos[j];
	                //guardamos el numero menor en el lugar correspondiente
	                periodos[j] = periodos[j+1];
	                //asignamos el auxiliar en el lugar correspondiente
	                periodos[j+1]=aux;	 
	          }
	     }	
	}
			
	for(j=0; j<periodos.length-1;j++)
	{	   
		var fechaFin    = generarFechaHora(periodos[j].fechaFin).getTime();		
		var fechaInicio = generarFechaHora(periodos[j+1].fechaInicio).getTime();
		
        if(fechaFin >= fechaInicio)
			resultado.mensaje = "El rango de fechas de los periodos debe ser excluyente.";		
                    
		else if( (fechaInicio - fechaFin) != 86400000) //existe una diferencia mayor a un dia 86400000		
			resultado.mensaje = "Los periodos deben ser secuenciales.";				
	}	
	
	if(resultado.mensaje != "")
		resultado.validacion = false;
	return resultado;
}

function validacionFeesInflacionYFechas(periodos){
	if(validacionForma)
	{				
		if($("#inflacion").val() != "")
		{
			var resultado = validaPorcentaje($("#inflacion").val());
			
			if(!resultado.validacion)
			{
				$("#labelError").text(resultado.mensaje).show();						
				showError(resultado.mensaje);
			}
			else
				$("#labelError").hide();		
			validacionForma = resultado.validacion;	
		}						
	}
	
	/*if(validacionForma)
	{			
		var resultado = validarFechasPeriodos(periodos);	
		if(!resultado.validacion)
		{
			$("#labelError").text(resultado.mensaje).show();			
			showError(resultado.mensaje);
		}
		else
			$("#labelError").hide();
		validacionForma = resultado.validacion;
	}*/	
}

Date.prototype.addHours = function(h) {    
	   this.setTime(this.getTime() + (h*60*60*1000)); 
	   return this;   
}

function generarFechaHora(fecha){
	var fecha = $.datepicker.parseDate('mm/dd/yy', fecha);
	var month = fecha.getUTCMonth(); //months from 1-12
	var day   = fecha.getUTCDate();
	var year  = fecha.getUTCFullYear();	
	var date  = new Date(Date.UTC(year, month, day, 0, 0, 0));
	return date;
}

function validaNumero(valor){
	var valido = true;
	if(isNaN(valor))	
	   valido = false;		
	else if(parseFloat(valor) < 0)	
		valido = false;		
	return valido;
}