var terminosValidateService = function($filter, $http, $q) {

	return {
				
		mensajeValidacion: function(valida, nombreTabla, mensaje){
			if(!valida)
			   showError("Verificar Registros de la tabla "+nombreTabla + mensaje);
			 return valida;
	    },	    	    
	    
	    convertirNumero: function(numero, tipoCast){
	    	//notacion matematica z: enteros, r: reales
		    if(tipoCast == "z")
		 	   numero = parseInt(numero.replace(/\$/g,"").replace(/%/g,"").replace(/,/g,""));		 		 
		 	else if(tipoCast == "r")
		 	   numero = parseDouble(numero.replace(/\$/g,"").replace(/%/g,"").replace(/,/g,""));
		 	return numero;
	    },	    
	    
	    validarLongitudCeldas: function(tabla, inicio, fin, indices){
	    	  var valida = true;		
	    	  
			  for(j=0; j< indices.length; j++)
			  {
				  for(var i=0; i< tabla.datos.length; i++)
				  {
					  if(tabla.datos[i][indices[j]].valor != null)
					  {
						  if(tabla.metadatos[indices[j]].max < tabla.datos[i][indices[j]].valor.length )
						  {
							  
							  tabla.mensajes[i] = "Verificar Registro, longitud de categoria excede 25 caracteres.";
							  valida = false;
						  }					 
						  else
							  tabla.mensajes[i] = "";  
					  }				  
					  if(!valida) break;
				  }  
				  if(!valida) break;
			  }		  
			  tabla.valida = valida;
			  return tabla;
	    },
	    
	    
	    validarCategoriasRepetidas: function(tabla, indice){
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length-1; i++)
			  {
				  for(var j=i+1; j< tabla.datos.length; j++)
				  {
					  if(tabla.datos[i][indice].valor == tabla.datos[j][indice].valor )
						  valida = false;
					  if(!valida) break;
				  }
				  if(!valida) break;
			  }
			  tabla.valida = valida;
			  return tabla;
	    },
	
	    validarCeldasVacias: function(tabla, indiceMax, mensaje){
	    	  
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length; i++)
			  {
				  for(var j=0; j< tabla.datos[0].length; j++)
				  {
					  if(j < indiceMax)
					  {
				
						  if(tabla.datos[i][j].valor == null || tabla.datos[i][j].valor === "")
						  {						 
							  if(mensaje)
							     tabla.mensajes[i] = "Verificar Registro, existen campos vac\u00EDos.";
							  if(valida)
								 valida = false;
						  }  
					  }						  
				  }
				  if(valida && mensaje)
					 tabla.mensajes[i] = "";
			  }		  
			  tabla.valida = valida;		  
			  return tabla;
	    },
	    
	    validarRangosTablas: function(tabla, columnaOrigen, columnaDestino, filaInicio){
	    	  var valida = true;
	    	  
			  for(var i=filaInicio; i< tabla.datos.length; i++)
			  {			 
				 
				 if(this.convertirNumero(tabla.datos[i][columnaOrigen].valor, "z") > this.convertirNumero(tabla.datos[i][columnaDestino].valor, "z"))
				 {						 
					 tabla.mensajes[i] = "Desde no pueder ser mayor a hasta.";
					 if(valida)
					    valida = false;
				 }				
				 else if( (i <= tabla.datos.length-2) && (this.convertirNumero(tabla.datos[(i+1)][columnaOrigen].valor, "z") - this.convertirNumero(tabla.datos[i][columnaDestino].valor, "z") ) != 1)
				 {						 
					 
					 tabla.mensajes[i] = "La diferencia entre rangos debe ser de 1.";
					 if(valida)
					    valida = false;
				 }
				 if(valida)
					 tabla.mensajes[i] = "";
			  }		  
			  tabla.valida = valida;		  
			  return tabla;
	    },
	
	    validarValoresMonedaTablas: function(tabla, filaInicio, filaFin, columna, numFormatos){
	    	  var valida    = true;		  
	    	  var numVacios = 0;
			      	  			  
			  for(var i=filaInicio; i<=filaFin; i++)
			  {					 
				  valida = true;
				  if(tabla.datos[i][columna].valor == null && tabla.datos[i][columna+1].valor == null && valida)					 
					 valida= false;						 					 
				  else if(tabla.datos[i][columna].valor == null && tabla.datos[i][columna+1].valor == "" && valida)					
					 valida= false;						 					 
				  else if(tabla.datos[i][columna].valor == "" && tabla.datos[i][columna+1].valor == null && valida)					 
					 valida= false;						 
					 
				  if(!valida)					 
					numVacios++;					 	 
			  }	 						  	  
			  
			  if( numFormatos > numVacios )
				  valida = true;
			  else
				  valida = false;
			  tabla.valida = valida;		  
			  return tabla;	    	
	    },
	    
	    validarTablasPorcentaje: function(tabla, columna){
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length; i++)
			  {
				  if(tabla.datos[i][columna].valor == null || tabla.datos[i][columna].valor == "" && valida)
				  {
					 valida= false;
					 break;
				  }					
				  if(!valida) break;				 				  	 			
			  }	  
			  tabla.valida = valida;		  
			  return tabla;	    	
	    },
	    
	    validarTablasRevenuePorcentaje: function(tabla, columna){
	    	  var valida = true;		  
			  for(var i=0; i< tabla.datos.length; i++)
			  {
				  if( parseFloat(tabla.datos[i][columna].valor) > 100)
				  {
					 valida= false;
					 break;
				  }					
				  if(!valida) break;				 				  	 			
			  }	  
			  tabla.valida = valida;		  
			  return tabla;	    	
	    },
	    
	    esStringVacio: function(valor){
	    	return valor ? valor.trim().length == 0 : true; 
	    }, 
	    
	    validarFechasPeriodos: function(periodos){	    	
	    	var resultado = {validacion : true, mensaje: ""};
	    	
	    	for(i=1; i<periodos.length;i++){
	    	     //recorreremos todos los elementos hasta n-i, tomar en cuenta los ultimos no tiene caso ya que ya estan acomodados.
	    	     for(j=0;j<(periodos.length-i);j++){
	    	
	    	          //comparamos	    	 
	    	          if($.datepicker.parseDate('mm/dd/yy',periodos[j].fechaInicio).getTime() > 
	    	             $.datepicker.parseDate('mm/dd/yy',periodos[j+1].fechaInicio).getTime()){
	    	                //guardamos el numero mayor en el auxiliar
	    	                var aux = periodos[j];
	    	                //guardamos el numero menor en el lugar correspondiente
	    	                periodos[j] = periodos[j+1];
	    	                //asignamos el auxiliar en el lugar correspondiente
	    	                periodos[j+1]=aux;	 
	    	          }
	    	     }	
	    	}
	    			
	    	for(j=0; j<periodos.length-1;j++)
	    	{	   
	    		var fechaFin    = this.generarFechaHora(periodos[j].fechaFin).getTime();		
	    		var fechaInicio = this.generarFechaHora(periodos[j+1].fechaInicio).getTime();
	    		
	            if(fechaFin >= fechaInicio)
	    			resultado.mensaje = "El rango de fechas de los periodos debe ser excluyente.";		
	                        
	    		else if( (fechaInicio - fechaFin) != 86400000) //existe una diferencia mayor a un dia 86400000		
	    			resultado.mensaje = "Los periodos deben ser secuenciales.";				
	    	}	
	    	
	    	if(resultado.mensaje != "")
	    		resultado.validacion = false;
	    	return resultado;  			
	    },		

	    generarFechaHora: function(fecha){
	    	var fecha = $.datepicker.parseDate('mm/dd/yy', fecha);
	    	var month = fecha.getUTCMonth(); //months from 1-12
	    	var day   = fecha.getUTCDate();
	    	var year  = fecha.getUTCFullYear();	
	    	var date  = new Date(Date.UTC(year, month, day, 0, 0, 0));
	    	return date;		
	    }

		
    };	
};

registraService("terminosValidateService", terminosValidateService);