package com.mx.dla.dda.contrato.condicionesLicense.bos;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.condicionesLicense.constants.TipoCondicion;
import com.mx.dla.dda.contrato.condicionesLicense.daos.PLFAnnioDAO;
import com.mx.dla.dda.contrato.condicionesLicense.daos.PlfRangoDAO;
import com.mx.dla.dda.contrato.condicionesLicense.daos.PlicenseDAO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlfAnnioDTO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlfRangoDTO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlicenseDTO;
import com.mx.dla.dda.contrato.condicionesLicense.exception.CondicionesLicenseException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class CondicionesLicenseBO extends BaseBO {
	
	@Autowired
	private CatalogosDAO catalogosDAO;
	
	@Autowired
	private PLFAnnioDAO plfAnnioDAO;
	
	@Autowired
	private PlfRangoDAO plfRangoDAO;
	
	@Autowired
	private PlicenseDAO  plicenseDAO;
	
	
	public PlicenseDTO buscarCondiciones(PlicenseDTO condiciones ) throws ParseException
	{
		PlicenseDTO c = plicenseDAO.buscarPlicense(condiciones.getIdContrato());
		condiciones.setMontoAnio(buscarPeriodoAnios(condiciones.getIdContrato(), condiciones.getFechaInicio(), condiciones.getFechaFin()));
		
		if(c != null){
			condiciones.setTipoAnio(c.getTipoAnio());
			condiciones.setTipoCondicion(c.getTipoCondicion());
			condiciones.setTipoPeriodoPago(c.getTipoPeriodoPago());
			//suscriptores / rangos se vargan via ajax
		}
		return condiciones;
	}
	
	
	public PlicenseDTO guardarCondiciones(PlicenseDTO condiciones ) throws CondicionesLicenseException
	{
		PlicenseDTO  p  = plicenseDAO.buscarPlicense(condiciones.getIdContrato());
		TipoCondicion tc = TipoCondicion.parse(condiciones.getTipoCondicion());
		if (tc == null) throw new CondicionesLicenseException("Condición incorrecta");
		if(p == null)
		{
			plicenseDAO.insertarPlicense(condiciones);
		}
		else{
			plicenseDAO.acualizarPlicense(condiciones);
		}
		
		plfAnnioDAO.borrarPlAnnio(condiciones.getIdContrato());
		plfRangoDAO.borrarPlRango(condiciones.getIdContrato());
		if(tc.equals(TipoCondicion.SUSCRIPTORES))
		{
			Long index = 0L;
			if(condiciones.getRango()!=null){
				for(int i=0 ; i<condiciones.getRango().size(); i++)
				{
					PlfRangoDTO r = condiciones.getRango().get(i);
					if(r != null){
						r.setIdSuscriptor(index);
						index++;
						r.setIdContrato(condiciones.getIdContrato());
						plfRangoDAO.insertarPlRango(r);
					}
				}
			}
		}
		else
		{
			for(int i=0 ; i<calculaDiferencia(condiciones.getFechaInicio(), condiciones.getFechaFin()); i++)
			{
				PlfAnnioDTO a = condiciones.getMontoAnio().get(i);
				a.setAnnio(new Long(i+1));
				a.setIdContrato(condiciones.getIdContrato());
				plfAnnioDAO.insertarPlAnnio(a);
			}
		}
		return condiciones;
		
	}
	
	public List<PlfRangoDTO> buscarSuscriptores(Long idContrato) throws ParseException
	{
		List<PlfRangoDTO> susc = plfRangoDAO.buscarPlRango(idContrato);
		return susc;
	}
	
	public List<PlfAnnioDTO> buscarPeriodoAnios(Long idContrato , Date fechaIni, Date fechaFin)
	{
		List<PlfAnnioDTO> aniosBD = plfAnnioDAO.buscarPlAnnios(idContrato);
		List<PlfAnnioDTO> anios = new ArrayList<PlfAnnioDTO>();
		
		Long dif = calculaDiferencia(fechaIni,fechaFin);
		
		
		if(aniosBD.size() != dif)
		{
			for(int i=0; i<dif ;i++)
			{
				if(aniosBD.size()<=i)
				{
					PlfAnnioDTO a = new PlfAnnioDTO();
					a.setMonto("");
					anios.add(a);
				}
				else
				{
					anios.add(aniosBD.get(i));
				}
			}
		}
		else
		{
			anios.addAll(aniosBD);
		}
		
		return anios;
	}
	
	public List<CatalogoDTO> buscarPeriodos()
	{
		return catalogosDAO.buscarPeriodosActivos();
	}
	
	@SuppressWarnings("deprecation")
	private Long calculaDiferencia(Date first, Date second)
	{
		Integer diff= 0;
		Integer diffYears = (second.getYear() - first.getYear())*12;
		diff = diffYears - first.getMonth();
		diff = diff + second.getMonth();
		logger.debug("total of months [{}]",diff);
		return diff.longValue();
	}

}
