package com.mx.dla.dda.reporte.amortizacion.baseActivos.bos;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.reporte.ws.dtos.ParamGeneraReporteDTO;
import com.mx.dla.dda.reporte.ws.dtos.ResponseGeneraReporteDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;


@Component
public class BaseActivosBO extends BaseBO{
	
	@Value("${uri.file.reporte.baseActivosSQL}")
	protected String uriSQL;
	
	 @Value("${uri.file.reporte.txtcpv}")
	    protected String uriTXT;
	
	
	@Autowired
	private DLARestClientFactory dlaRestClientFactory;
	
	ArrayList<String> textoSQLReporte = new ArrayList<String>();
	
	ResponseGeneraReporteDTO responseDTO = null;
	
	public ResponseGeneraReporteDTO generaReporteBaseActivos(String fileName, Long anio, Long anioFin ) throws IOException
	{
		//--------- Se crea el archivo .sql en el servidor -------//
		//--- Variable con el Query en un String ----------//
		String fecha = anio.toString();

		String fechaFin = anioFin.toString();
		
		
		
		textoSQLReporte.clear();
		
		
		textoSQLReporte.add("SET trimspool ON;");
        
		textoSQLReporte.add("SET heading OFF;");
        
		textoSQLReporte.add("SET headsep OFF;");
        
		textoSQLReporte.add("SET linesize 20000;");
        
		textoSQLReporte.add("SET pagesize 0;");
        
		textoSQLReporte.add("SET TERMOUT OFF;");
        
		textoSQLReporte.add("SET NEWPAGE 0;");
        
		textoSQLReporte.add("SET SPACE 0;");
        
		textoSQLReporte.add("SET ECHO OFF;");
        
		textoSQLReporte.add("SET FEEDBACK OFF;");
        
		textoSQLReporte.add("SET MARKUP HTML OFF SPOOL OFF;");
        
		textoSQLReporte.add("SET VERIFY OFF;");
        
		textoSQLReporte.add("SET DEFINE OFF;");
        
		textoSQLReporte.add("SET serveroutput on size 1000000;");
        
		textoSQLReporte.add("spool "+ uriTXT +fileName+".txt;");
        
		
		
		
		
		textoSQLReporte.add("--[BEGIN]");
		textoSQLReporte.add("select 'GRUPO|APARTADO|ID_SAP|ESTUDIO|CONTRATO|CONT_INICIO|CONT_FIN|ID|ID_BV|TITULO|NOMBRE_UNICO|TEMPORADA|EPISODIO|FECHA_INICIO|FECHA_FIN|COSTO|ANNIO|ENERO|FEBRERO|MARZO|ABRIL|MAYO|JUNIO|JULIO|AGOSTO|SEPTIEMBRE|OCTUBRE|NOVIEMBRE|DICIEMBRE|TOTAL|' as X from dual;");
		textoSQLReporte.add("--[END_HEADER]");
		textoSQLReporte.add("select GRUPO||'|'||APARTADO||'|'||ID_SAP||'|'||ESTUDIO||'|'||NUMERO_CONTRATO||'|'||C_FECHA_INICIO||'|'||C_FECHA_FIN||'|'||ID||'|'||ID_BV||'|'||TITULO||'|'||NOMBRE_UNICO||'|'||TEMPORADA||'|'||EPISODIO||'|'||FECHA_INICIO||'|'||FECHA_FIN||'|'||COSTO||'|'|| ");
		textoSQLReporte.add(" ANNIO||'|'||MES_1||'|'||MES_2||'|'||MES_3||'|'||MES_4||'|'||MES_5||'|'||MES_6||'|'||MES_7||'|'||MES_8||'|'||MES_9||'|'||MES_10||'|'||MES_11||'|'||MES_12||'|'||(MES_1 + MES_2 + MES_3 + MES_4 + MES_5 + MES_6 + MES_7 + MES_8 + MES_9 + MES_10 + MES_11 + MES_12)||'|' as X");
		textoSQLReporte.add(" from ( select NVL( GRUPO, '' ) as GRUPO, APARTADO, ID_SAP, NVL( ESTUDIO, 'Total' ) as ESTUDIO, NUMERO_CONTRATO, C_FECHA_INICIO, C_FECHA_FIN, ID_TITULO_CNTORIG as ID, ID_BV, TITULO,nombre_unico, TEMPORADA, EPISODIO, FECHA_INICIO, FECHA_FIN, COSTO, ANNIO, ");
		textoSQLReporte.add(" ROUND( SUM(MES_1), 4 ) as MES_1, ROUND( SUM(MES_2), 4 ) as MES_2, ROUND( SUM(MES_3), 4 ) as MES_3, ROUND( SUM(MES_4), 4 ) as MES_4, ROUND( SUM(MES_5), 4 ) as MES_5, ROUND( SUM(MES_6), 4 ) as MES_6, ROUND( SUM(MES_7), 4 ) as MES_7, ");
		textoSQLReporte.add(" ROUND( SUM(MES_8), 4 ) as MES_8, ROUND( SUM(MES_9), 4 ) as MES_9, ROUND( SUM(MES_10), 4 ) as MES_10, ROUND( SUM(MES_11), 4 ) as MES_11, ROUND( SUM(MES_12), 4 ) as MES_12 ");    
		textoSQLReporte.add(" from ( select grp.DESC_GRUPO as GRUPO, ado.DESC_APARTADO as APARTADO, est.ID_SAP, est.DESC_ESTUDIO as ESTUDIO, sub.ID_CONTRATO_ORIGINAL, cnt.NUMERO_CONTRATO, to_char( cnt.FECHA_INICIO, 'dd/mm/yyyy' ) as C_FECHA_INICIO, to_char( cnt.FECHA_FIN, 'dd/mm/yyyy' ) as C_FECHA_FIN, ");
		textoSQLReporte.add(" sub.ID_TITULO_CNTORIG, tit.TITULO,tit.nombre_unico, tit.TEMPORADA, tit.EPISODIO, tit.ID_BV, tit.COSTO, to_char( tit.FECHA_INICIO, 'dd/mm/yyyy' ) as FECHA_INICIO, to_char( tit.FECHA_FIN, 'dd/mm/yyyy' ) as FECHA_FIN, sub.ANNIO, sub.MES_1, sub.MES_2, sub.MES_3, sub.MES_4, sub.MES_5, sub.MES_6, sub.MES_7, sub.MES_8, sub.MES_9, sub.MES_10, sub.MES_11, sub.MES_12 ");
		textoSQLReporte.add(" from ( select ID_CONTRATO_ORIGINAL, ID_TITULO_CNTORIG, ANNIO, SUM( MES_1 ) as MES_1, SUM( MES_2 ) as MES_2, SUM( MES_3 ) as MES_3, SUM( MES_4 ) as MES_4, SUM( MES_5 ) as MES_5, SUM( MES_6 ) as MES_6, SUM( MES_7 ) as MES_7, SUM( MES_8 ) as MES_8, SUM( MES_9 ) as MES_9, SUM( MES_10 ) as MES_10, SUM( MES_11 ) as MES_11, SUM( MES_12 ) as MES_12 ");
		textoSQLReporte.add(" from ( select ID_CONTRATO_ORIGINAL, ID_TITULO_CNTORIG, ANNIO, NVL( MES_1, 0 ) as MES_1, NVL( MES_2, 0 ) as MES_2, NVL( MES_3, 0 ) as MES_3, NVL( MES_4, 0 ) as MES_4, NVL( MES_5, 0 ) as MES_5, NVL( MES_6, 0 ) as MES_6, NVL( MES_7, 0 ) as MES_7, NVL( MES_8, 0 ) as MES_8, NVL( MES_9, 0 ) as MES_9, NVL( MES_10, 0 ) as MES_10, NVL( MES_11, 0 ) as MES_11, NVL( MES_12, 0 ) as MES_12 ");
		textoSQLReporte.add(" from ( select distinct amor.ID_CONTRATO_ORIGINAL, amor.ID_TITULO_CNTORIG, TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) as ANNIO, TO_NUMBER( TO_CHAR( amor.MES, 'mm' ) ) as MESES, amor.MES, TO_NUMBER( amor.MONTO ) as MONTO from DDA_T_AMORTIZACION amor where TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) >= ");
		textoSQLReporte.add( fecha +" and TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) <= " + fechaFin  );
		textoSQLReporte.add(" ) PIVOT( SUM( MONTO ) FOR MESES in ( 1 as MES_1, 2 as MES_2, 3 as MES_3, 4 as MES_4, 5 as MES_5, 6 as MES_6, 7 as MES_7, 8 as MES_8, 9 as MES_9, 10 as MES_10, 11 as MES_11, 12 as MES_12 ) ) ) group by  ID_CONTRATO_ORIGINAL, ID_TITULO_CNTORIG, ANNIO ) sub, ");
		textoSQLReporte.add(" ( SELECT scnt.ID_CONTRATO_ORIGINAL as ID_CONTRATO, ct.ID_TITULO_CNTORIG, ct.ID_BV, ct.DESC_TITULO AS TITULO,ct.nombre_unico, ct.TEMPORADA, ct.EPISODIO, ct.FECHA_INICIO, ct.FECHA_FIN, ct.COSTO FROM DDA_T_CONTRATO_TITULO ct, ( SELECT ID_CONTRATO_ORIGINAL, MAX( ID_CONTRATO ) AS ID_CONTRATO FROM DDA_T_CONTRATO WHERE ID_TIPO_CONTRATO = 1 GROUP BY ID_CONTRATO_ORIGINAL ) scnt WHERE ct.ID_CONTRATO = scnt.ID_CONTRATO ) tit, ");
		textoSQLReporte.add(" DDA_T_CONTRATO cnt, DDA_C_ESTUDIO est, DDA_C_ESTUDIO_GRUPO grp, DDA_T_APARTADO ado where sub.ID_CONTRATO_ORIGINAL = cnt.ID_CONTRATO and cnt.ID_ESTUDIO = est.ID_ESTUDIO and est.ID_GRUPO = grp.ID_GRUPO and sub.ID_TITULO_CNTORIG = tit.ID_TITULO_CNTORIG and cnt.ID_CONTRATO = tit.ID_CONTRATO ");
		textoSQLReporte.add(" and cnt.ID_APARTADO = ado.ID_APARTADO and cnt.ID_ESTATUS in ( 4, 5, 6 ) ) group by grouping sets ( ( ANNIO ), ( GRUPO, APARTADO, ID_SAP, ESTUDIO, NUMERO_CONTRATO, C_FECHA_INICIO, C_FECHA_FIN, ID_TITULO_CNTORIG, ID_BV, TITULO,nombre_unico, TEMPORADA, EPISODIO, FECHA_INICIO, FECHA_FIN, COSTO, ANNIO ) ) ORDER BY ANNIO, GRUPO nulls last, ESTUDIO nulls last, TITULO );");
		textoSQLReporte.add("--[END]");
		textoSQLReporte.add("quit");
		
		logger.info("Archivo: [{}]", fileName);
		
		//File file = new File("D:\\Software\\paco\\" + fileName + ".sql" );
		File file = new File( uriSQL + fileName + ".sql" );
		FileUtils.writeLines(file, textoSQLReporte);
		
		logger.debug("busca archivo en [{}]",file.getAbsolutePath());
		
		if( file.exists() )//-- Si se crea el archivo se ejecuta el WS
		{
			try{
				
				logger.info("se envia el WS generaReporteWS.");
				responseDTO = generaReporteWS(fileName);
				
			}catch (Exception e){
				logger.debug(e.toString());
			}		
			
		}//Termina if( file.exists() )
			
		return responseDTO;
	}
	
	
	
	public ResponseGeneraReporteDTO generaReporteBaseActivos(String fileName, String anio, String anioFin, Boolean estatus ) throws IOException
	{
		//--------- Se crea el archivo .sql en el servidor -------//
		//--- Variable con el Query en un String ----------//
		String fecha = anio.toString();

		String fechaFin = anioFin.toString();
		
		
		
		textoSQLReporte.clear();
		
		
		textoSQLReporte.add("SET trimspool ON;");
        textoSQLReporte.add("SET heading OFF;");
        textoSQLReporte.add("SET headsep OFF;");
        textoSQLReporte.add("SET linesize 20000;");
        textoSQLReporte.add("SET pagesize 0;");
        textoSQLReporte.add("SET TERMOUT OFF;");
        textoSQLReporte.add("SET NEWPAGE 0;");
        textoSQLReporte.add("SET SPACE 0;");
        textoSQLReporte.add("SET ECHO OFF;");
        textoSQLReporte.add("SET FEEDBACK OFF;");
        textoSQLReporte.add("SET MARKUP HTML OFF SPOOL OFF;");
        textoSQLReporte.add("SET VERIFY OFF;");
        textoSQLReporte.add("SET DEFINE OFF;");
        textoSQLReporte.add("SET serveroutput on size 1000000;");
        textoSQLReporte.add("spool "+ uriTXT +fileName+".txt;");
        
        textoSQLReporte.add("select 'Estudio|Contrato|Nombre nico|Nombre estndar|Id Broadview|Temporada|Episodio|Inicio vigencia|Fin vigencia|VU|Categora|Costo' from dual;");
        textoSQLReporte.add("--[BEGIN]");
        textoSQLReporte.add("select"); 
        textoSQLReporte.add("est.DESC_ESTUDIO||'|'||");
        textoSQLReporte.add("cnt.numero_contrato||'|'||");
        textoSQLReporte.add("tit.nombre_unico||'|'||");
        textoSQLReporte.add("tit.desc_titulo||'|'||");
        textoSQLReporte.add("tit.ID_BV||'|'||");
        textoSQLReporte.add("tit.Temporada||'|'||");
        textoSQLReporte.add("tit.Episodio||'|'||");
        textoSQLReporte.add("TO_CHAR(tit.fecha_inicio,'dd/mm/yyyy')||'|'||");
        textoSQLReporte.add("TO_CHAR(tit.fecha_fin,'dd/mm/yyyy')||'|'||");
        textoSQLReporte.add("tit.VIDA_UTIL||'|'||");
        textoSQLReporte.add("cat.desc_categoria||'|'||");
        textoSQLReporte.add("tit.Costo");
        textoSQLReporte.add("from ");
        textoSQLReporte.add("dda_t_contrato_titulo tit right join dda_t_contrato cnt on cnt.id_contrato = tit.id_contrato right join dda_c_estudio est on cnt.id_estudio = est.id_estudio,");
        textoSQLReporte.add("dda_c_categoria cat");
        textoSQLReporte.add("where ");
        textoSQLReporte.add("tit.fecha_inicio >= to_date('"+anio+"','dd/MM/yyyy')"); 
        textoSQLReporte.add("and tit.fecha_fin <= to_date('"+anioFin+"','dd/MM/yyyy')"); 
        textoSQLReporte.add("and tit.ID_CATEGORIA_TIT = cat.id_categoria");
        if(estatus)
        textoSQLReporte.add("and tit.estatus = 'ACTIVO'");
        
        textoSQLReporte.add("order by tit.fecha_inicio;");
        textoSQLReporte.add("--[END]");
		textoSQLReporte.add("quit");
		
		logger.info("Archivo: [{}]", fileName);
		
		//File file = new File("C:\\Software\\apache-tomcat-7.0.67\\" + fileName + ".sql" );
		File file = new File( uriSQL + fileName + ".sql" );
		FileUtils.writeLines(file, textoSQLReporte);
		
		logger.debug("busca archivo en [{}]",file.getAbsolutePath());
		
		if( file.exists() )//-- Si se crea el archivo se ejecuta el WS
		{
			try{
				
				logger.info("se envia el WS generaReporteWS.");
				responseDTO = generaReporteWS(fileName);
				
			}catch (Exception e){
				logger.debug(e.toString());
			}		
			
		}//Termina if( file.exists() )
			
		return responseDTO;
	}
	
	
	
	
	
	
	
	
	
	
	public ResponseGeneraReporteDTO generaReporteWS( String archivo ) {
			
		DLARestClient client = dlaRestClientFactory.getClient(DLARestServices.GENERA_REPORTE_AMORTIZACION_BA);
		ParamGeneraReporteDTO request = new ParamGeneraReporteDTO();
			
		logger.info("Antes de configurar parmetros.");
		request.setNombreArchivo(archivo);			
		request.setFormato("txt");			
		request.setComprimir("y");
		logger.info("Despues de configurar parmetros.");
		
		logger.info("Request rest ReporteAmortBaseActivos [{}]",request);
		ResponseGeneraReporteDTO response = client.get(request, ResponseGeneraReporteDTO.class);
		logger.info("Response rest ReporteAmortBaseActivos [{}]",response);
		
		return response;
	
	}

}