package com.mx.dla.dda.reporte.movimientos.bos;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.reporte.movimientos.daos.ReporteMovimientosDAO;
import com.mx.dla.dda.reporte.movimientos.dtos.ReporteMovimietosDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteRowDTO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class ReporteMovimientosBO extends BaseBO {
	
	@Autowired
	private ReporteMovimientosDAO reporteMovimientos;
	
	@Autowired
	protected ExcelMapperTransform excelMapperTransform;
	
	@Autowired
	private ExcelMapperContext excelMapperContext;
	
	public List<ReporteMovimietosDTO> obtenerDatosReporte(String contrato, String estudio, String mes){
		
		List<ReporteMovimietosDTO> reporte = reporteMovimientos.obtenerReporteMovimientos(contrato, estudio, mes);
		
		for (ReporteMovimietosDTO data : reporte){
			data.setMovimiento("");
			if(!data.getBaja().equals("NO")){
				data.setMovimiento(data.getBaja());
			}
			if(!data.getCambioCosto().equals("NO")){
				data.setMovimiento(data.getCambioCosto());
			}
			if(!data.getVidaUtil().equals("NO")){
				data.setMovimiento(data.getVidaUtil());
			}
			if(data.getMovimiento().isEmpty()){
				data.setMovimiento("ALTA");
			}
		}
		
		return reporte;
	}

	public InputStream obtenerReporteEnExcel(String contrato, String estudio, String mes) {
		byte[] info = null;
		InputStream reporte = null;
		ExcelMapper mapper = excelMapperContext.getExcelMapper("reporteMovimientos");
		logger.info("{}", mapper);
		String[] encabezado = { "ID BV", "ACTIVO", "MOVIMIENTO", "FECHA NOTIF SAP", "CODIGO DDA", "DESC TITULO", "CONTRATO DDA", "FECHA INICIO", "FECHA FIN", "COSTO", "FECHA CONTABILIZACION"};
		List<ReporteMovimietosDTO> reporteInfo = null;
		try{
			for(int i = 0; i < encabezado.length; i++) {
				String s = String.format(mapper.getRules().get(i).getHeader(), encabezado[i]);
				mapper.getRules().get(i).setHeader(s);
			}
			reporteInfo = obtenerDatosReporte(contrato, estudio, mes);
			logger.info("{}", mapper);
			info = excelMapperTransform.transformObjectToExcel(reporteInfo, mapper, ReporteMovimietosDTO.class);
			reporte = new ByteArrayInputStream(info);
		}catch(Exception e){
			logger.error("Error : " + e);
		}
		return reporte;
	}

}
