package com.mx.dla.dda.factura.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;


public enum TipoPagoFactura implements Catalogable{

	MINIMO_GARANTIZADO("MINIMO","MINIMO GARANTIZADO"),
	OVERAGE("OVERAGE","OVERAGE")
	;
	
	private String type;
	
	private String desc;
	
	TipoPagoFactura(String type , String desc)
	{
		this.type = type;
		this.desc = desc;
	}
	
	public String getDesc() {
		return desc;
	}
	public String getType() {
		return type;
	}
	
	@Override
	public String getValue() {
		return type;
	}
	
	public static TipoPagoFactura parse(String tipo)
	{
		TipoPagoFactura [] values = TipoPagoFactura.values();
		TipoPagoFactura target = null;
		for(TipoPagoFactura t : values)
		{
			if(t.getType().equals(tipo))
			{
				target = t;
				break;
			}
		}
		return target;
		
	}
}

