package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.CategoriasDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class CategoriasAction extends BaseAction {

	private static final long serialVersionUID = 1L;
	private List<CategoriasDTO> categorias;
	private CategoriasDTO categoria;
	private String nombreCategoria;
	private String idCategoria;

	@Autowired
	private TransaccionesBO transacciones;

	@Override
	public String execute() {
		setPmns();
		return SUCCESS;
	}

	public String listadoCategorias() throws TransaccionException {

		try {
			setCategorias(transacciones.getCategorias());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public void setPmns() {
		logger.info("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 212);
		this.getSession().put("pmnReturn", 212);
		this.setPmn("212");
		this.setPmnReturn("212");
	}

	public String dirigirAgregar() {
		setPmns();
		return SUCCESS;
	}

	public String guardaCategoria() throws TransaccionException {
		CategoriasDTO categoria = new CategoriasDTO();
		categoria.setNombre(nombreCategoria.toUpperCase());

		try {
			transacciones.agregarCategoria(categoria);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String eliminaCategoria() throws TransaccionException {
		CategoriasDTO categoria = new CategoriasDTO();
		categoria.setIdCategoria(idCategoria);
		categoria.setBorrado("0");

		try {
			transacciones.eliminarCategoria(categoria);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String llamaObtenCategorias() throws TransaccionException {

		try {
			setCategoria(transacciones.getCategoriaById(idCategoria));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String llamaActualizaCategoria() throws TransaccionException {
		CategoriasDTO categoria = new CategoriasDTO();
		categoria.setIdCategoria(idCategoria);
		categoria.setNombre(nombreCategoria.toUpperCase());

		try {
			transacciones.updateCategoria(categoria);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPmns();
		return SUCCESS;
	}

}
