package com.mx.dla.dda.contrato.generales.actions;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class EliminaContratoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idContratoP;
	private boolean seElimino;

	@Autowired
	private GeneralesBO generalesBO;

	@Override
	public String execute() throws TransaccionException {

		try {
			logger.debug("idContrato a eliminar : [{}]", idContratoP);
			seElimino = generalesBO.eliminaContrato(idContratoP);
			logger.debug("respuesta de eliminar contrato : [{}]", seElimino);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public void setIdContratoP(Long idContratoP) {
		this.idContratoP = idContratoP;
	}

	public Long getIdContratoP() {
		return idContratoP;
	}

	public void setSeElimino(boolean seElimino) {
		this.seElimino = seElimino;
	}

	public boolean getSeElimino() {
		return seElimino;
	}
}
