package com.mx.dla.dda.reporte.pago.actions;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReporteContingenciaBO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteInterfazContingenciaDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoDTO;

public class ReporteContingenciaAction extends BaseContratoAction {
	private static final long serialVersionUID = 1L;

	private List<String> idCon;
	private Date fechaInicio;
	private Date fechaFin;
	private String[] llaves;
	private List<ReportePagoDTO> infoReporte;
	private Long idEstudio;
	private List<ReporteInterfazContingenciaDTO> reporte;
	private String[] encabezado;

	@Autowired
	private ReporteContingenciaBO ReporteContingenciaBO;

	public String execute() {
		setEncabezado(ReporteContingenciaBO.obtenerEncabezado());
		reporte = ReporteContingenciaBO.obteneReporte(idCon, idEstudio);
		return SUCCESS;
	}

	public void setIdCon(List<String> idCon) {
		this.idCon = idCon;
	}

	public List<String> getIdCon() {
		return idCon;
	}

	public void setFechaInicio(Date fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	public Date getFechaInicio() {
		return fechaInicio;
	}

	public void setFechaFin(Date fechaFin) {
		this.fechaFin = fechaFin;
	}

	public Date getFechaFin() {
		return fechaFin;
	}

	public void setLlaves(String[] llaves) {
		this.llaves = llaves;
	}

	public String[] getLlaves() {
		return llaves;
	}

	public void setInfoReporte(List<ReportePagoDTO> infoReporte) {
		this.infoReporte = infoReporte;
	}

	public List<ReportePagoDTO> getInfoReporte() {
		return infoReporte;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setReporte(List<ReporteInterfazContingenciaDTO> reporte) {
		this.reporte = reporte;
	}

	public List<ReporteInterfazContingenciaDTO> getReporte() {
		return reporte;
	}
	
	public void setEncabezado(String[] encabezado) {
		this.encabezado = encabezado;
	}
	
	public String[] getEncabezado() {
		return encabezado;
	}
}
