var mesConsulta = 0;
var anioConsulta = 0;
var totalActual=0;	
$(document).ready(function(){
		    
	    //**********Se inicializan elementos html***********         
       $( "#mesAnterior" ) .prop( "disabled", true );
       $( "#mesSiguiente" ).prop( "disabled", true );
       $( "#guardar" )     .prop( "disabled", true );       
       $("#cargar").prop("disabled", true);
       
       
       $("#mesAnterior").click(function()  
       {
    	   var mes  = $('#mesAnterior').attr('mes');
    	   var anio = $('#mesAnterior').attr('anio');
    	       	       	   
    	   limpiarTabla();
    	   cargarInformacion(mes, anio, false);    	   
    	   actualizarBotones(parseInt(mes), parseInt(anio)); 
    	   
    	   if(parseInt(mes) < 10 )
    		   mes = "0"+mes;
    	   
    	   $('#fecha').val(mes + '/01' + '/'+anio);   
    	   
       });
       
       $("#mesSiguiente").click(function ()  
       {       	   
    	   var mes  = $('#mesSiguiente').attr('mes');
    	   var anio = $('#mesSiguiente').attr('anio');
    	       	      	       	   
    	   if( (new Date('01/'+mes+'/'+anio).getTime() > new Date('01/'+(mesConsulta+1)+'/'+anioConsulta).getTime()))    		       	   
    	   {
    		   $( "#mesSiguiente" ) .prop( "disabled", true );
    	   }
    	   else
    	   {    		           	   
        	   limpiarTabla();
        	   cargarInformacion(mes, anio, false);    	   
        	   actualizarBotones(parseInt(mes), parseInt(anio)); 
        	   if(parseInt(mes) < 10 )
        		  mes = "0"+mes;
        	   
        	   $('#fecha').val(mes + '/01' + '/'+anio);  
        	   $( "#mesSiguiente" ) .prop( "disabled", false );
    	   } 
    	   
       });
       
       $("#consultar").click(function ()  
       {    	       	    	   	
    	   sePresionoConsultar();
       });

       $("#cargar").click(function () {
    	   sePresionoConsultar();
    	});
             
       $("#guardar").click(function () 
       {
    	   $( "#gifLoad" ).show();
           $( "#guardar" ).prop( "disabled", true );
    	   actualizarDatos();    	       	   
       });                    
       $("#fecha").datepicker( { dateFormat: 'mm/dd/yy' } );
       
       $("#fecha").change(function() {
    	   $("#cargar").prop("disabled", false);
    	 });
       
});

function sePresionoConsultar() {
	
	if( $('#fecha').val() != "" && validarFecha($('#fecha').val())){
		   
		var fecha =  $('#fecha').val().split("/");
 	   
 	   limpiarTabla();
 	   mesConsulta  = parseInt(fecha[0]);
 	   anioConsulta = parseInt(fecha[2]);
 	   
 	   cargarInformacion(mesConsulta, anioConsulta, true);    	   
 	   actualizarBotones(mesConsulta, anioConsulta);    	   
 	   	    	  
 	   $('#labelError').hide();
 	   
 	   //se habilitan el resto de los botones
 	   $( "#mesAnterior" ) .prop( "disabled", false );
	       $( "#mesSiguiente" ).prop( "disabled", false );
	       $( "#guardar" )     .prop( "disabled", false );
	       $("#cargar").prop("disabled", false);
	       $("#plantillaLink").show();

	   }
    else
    {	    	   	    	  	    	   
 	   showError("Error en el formato de la fecha o falta fecha.");	    	  
    }
	
}

function unFormat(value){
	var numero="";
	if(value.length>0){
		var arreglo=value.split(',');		
		for(var i=0;i<arreglo.length;i++){
			numero+=arreglo[i]+"";
		}
	}else{
		numero=0;
	}
	
	return parseInt(numero);
}

function format(value){
	var n = parseFloat(value);
	n = "$ " + n.formatDLA();
	return n;
}

function formatMiles(value){	
	var n = parseFloat(value);
	n =  n.formatDLA();
	n = n.substring(0,n.length-3);
	return n;
}
function cargarInformacion(mes, anio, consulta){
	
	$.post( contextPath + '/carga/suscripcion/getCargaSuscriptores', 
			{ mes: mes, annio:anio }
		  )
	 .done(function( response ) 
	  {
      	  if(response.msgError != null)
        	 showError(response.msgError);        	
          else{
        		crearTablaDatos(response.listado, consulta);
        		crearTabla();
          }        	        	 
	  });	
}


function actualizaInformacion(informacionExcel) {
	var suma = 0;
	var llave;
	var valor;
	
	$("#tablaSuscriptores tbody tr").each(function(index) {		 
		llave = $(this).children("td")[1].innerHTML;
		llave = llave.trim();
		valor = informacionExcel[llave];
		
		if(llave != "TOTAL"){
			
			if(valor != null && valor != undefined && valor != "") {//se coloca el valor a actulizar y se suma para el total
				$("#Suscriptores_" + (index + 1)).val(formatMiles(valor));
				$("#Suscriptores_" + (index + 1)).attr("cambio","1");
				suma += Number(valor);
			}else { //si no tenemos llave de actualizacion se toma el valor del input para el total
				suma += unFormat($("#Suscriptores_" + (index + 1)).val());
			}
			
		}
		else 
		{
			$(this).children("td")[7].innerHTML = formatMiles(suma);			
		}		
	});
}

function descargaPlantilla() {
	var id = 5
	var empresas = [];
	var i=0;
	
	$("#tablaSuscriptores tbody tr").each(function(index) {		 
		llave = $(this).children("td")[1].innerHTML;
		llave = llave.trim();
		
		if(llave != "TOTAL"){
			empresas[i++] = llave
		}	
	});
	
	var url = contextPath +'/carga/suscripcion/descargarPlantilla.action?id=' + id+ '&empresas=' + empresas;
   	window.open(url);
}


function crearTablaDatos(data, consulta){	
	  var tabla = '<table id="tablaSuscriptores" class="table">' +
						'<thead>' +
						  '<tr class="encabezado">' +
							 '<th> Regi\u00F3n </th>' +
					         '<th> Empresa     </th>' +     	  							  
							 '<th>' + data[0].mes5 + '</th>' +
							 '<th>' + data[0].mes4 + '</th>' +
							 '<th>' + data[0].mes3 + '</th>' +
							 '<th>' + data[0].mes2 + '</th>' +
							 '<th>' + data[0].mes1 + '</th>' +
							 '<th>' + data[0].mesActual + '</th>'+
							
	                       '</tr>' +
	                    '</thead>' + 
	                    '<tbody></tbody></table>';

	  $('#divTabla').append(tabla);	   
	  
	  var fila = "";
	  var tMes5=0;
	  var tMes4=0;
	  var tMes3=0;
	  var tMes2=0;
	  var tMes1=0;
	  
	  var tMesActual=0;
	  
	  for (var i=1; i<data.length; i++){		                   
		  
		   fila =  '<tr><td>' + data[i].region      +'</td>'+
	               '<td>' + data[i].empresa     +'</td>'+	               
	               '<td>' + data[i].mes5        +'</td>'+
	               '<td>' + data[i].mes4        +'</td>'+
	               '<td>' + data[i].mes3        +'</td>'+
	               '<td>' + data[i].mes2        +'</td>'+
	               '<td>' + data[i].mes1        +'</td>';
	               
					   tMes5+=unFormat(data[i].mes5);
					   tMes4+=unFormat(data[i].mes4);
					   tMes3+=unFormat(data[i].mes3);
					   tMes2+=unFormat(data[i].mes2);
					   tMes1+=unFormat(data[i].mes1);
					   
					   tMesActual+=unFormat(data[i].mesActual);
					   
	               if(consulta == true)
	               {
		               fila = fila + '<td> <input type="text" idEmpresa="' + data[i].idEmpresa +
		                                     '" idCarga="' + data[i].idCarga + 
		                                     '" id="Suscriptores_' + i +
		                                     '" value="' + data[i].mesActual +'" class="form-control actual" style="text-align: right;" onblur="sumar()" onchange="validarMonto('+i+')"></td></tr>';
	               }
	               else
	               {
	            	   fila = fila + '<td style="text-align: right;">' + data[i].mesActual +'</td></tr>';
	            	   
	               }
	                   		   		   		   		   
         $('#tablaSuscriptores tbody:last').append(fila);         
         fila = "";                  
	  }
	  sumar();

	if(!consulta)
	   totalActual=formatMiles(tMesActual);
		
	$('#tablaSuscriptores tbody:last').append('<tr><td></td><td>TOTAL</td><td>'+formatMiles(tMes5)+'</td><td>'+formatMiles(tMes4)+'</td><td>'+formatMiles(tMes3)+'</td><td>'+formatMiles(tMes2)+'</td><td>'+formatMiles(tMes1)+'</td><td id="total" style="text-align: right;">'+totalActual+'</td></tr>');
	$("#tablaSuscriptores tbody input").change(function(){
		  $(this).attr("cambio","1");		  
		  $(this).val(addCommas($(this).val().replace(",","")));		   
	});
}

function crearTabla(){
	
	$('#tablaSuscriptores').DataTable({
	    "language": {
	        "sProcessing":    "Procesando...",
	        "sLengthMenu":    "Mostrar _MENU_ registros",
	        "sZeroRecords":   "No se encontraron resultados",
	        "sEmptyTable":    "No hay datos que satisfagan los criterios de b\u00FAsqueda",
	        "sInfo":          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
	        "sInfoEmpty":     "Mostrando registros del 0 al 0 de un total de 0 registros",
	        "sInfoFiltered":  "(filtrado de un total de _MAX_ registros)",
	        "sInfoPostFix":   "",
	        "sSearch":        "Buscar:",
	        "sUrl":           "",
	        "sInfoThousands":  ",",
	        "sLoadingRecords": "Cargando...",
	        "oPaginate": {
	            "sFirst":    "Primero",
	            "sLast":    "Último",
	            "sNext":    "Siguiente",
	            "sPrevious": "Anterior"
	        },
	        "oAria": {
	            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
	            "sSortDescending": ": Activar para ordenar la columna de manera descendente"
	        }
	    },bFilter: false, bInfo: false, "bSort": false, "bPaginate" : false
	});
	
}

function limpiarTabla(){
	$('#divTabla').empty();
	$('#tablaSuscriptores').remove();		
}

function actualizarBotones(mes, anio){      
	  var meses = ["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"];
	  
	  var siguiente = mes + 1;
	  var anterior  = mes - 1;
	  
	  var anioSiguiente = anio;
	  var anioAnterior  = anio;
	  
	  if(siguiente > 12){
		  siguiente = 1;
		  anioSiguiente++;
	  }
	  
	  if(anterior < 1){
		  anterior = 12;
		  anioAnterior--;
	  }
	  
	  $("#mesSiguiente").text(meses[siguiente-1] +'-' + anioSiguiente);
	  $("#mesAnterior") .text( meses[anterior-1]  +'-' + anioAnterior);

	  $('#mesSiguiente').attr('mes' , siguiente);
	  $('#mesSiguiente').attr('anio', anioSiguiente);
	  $('#mesAnterior') .attr('mes' , anterior);
	  $('#mesAnterior') .attr('anio', anioAnterior);
	  
	   var mes  = $('#mesSiguiente').attr('mes');
	   var anio = $('#mesSiguiente').attr('anio');
	   
	   if( (new Date('01/'+mes+'/'+anio).getTime() > new Date('01/'+(mesConsulta+1)+'/'+anioConsulta).getTime()))	   	  
		   $( "#mesSiguiente" ) .prop( "disabled", true );	   
	   else	       		           	   
		   $( "#mesSiguiente" ) .prop( "disabled", false );	   
}

function actualizarDatos(){

	 var suscripciones = [];
	 var rows = $('#tablaSuscriptores tbody').find('tr').length;    	       	       	       	   
	   
	 var fecha = $('#fecha').val().split("/");
	 var mes   = parseInt(fecha[0]);
	 var anio  = parseInt(fecha[2]);
	 	 
	 var contador = 0;
	 for(var i=1; i <= rows; i++)
	 {		   
		   if($('#Suscriptores_'+i).attr("cambio") == "1")
		   {
			   var valor         = $('#Suscriptores_'+i).val().replace(",","").replace(" ", "");
			   var suscriptoresV = valor == "" ? null : valor;		 	   			  
			   var idCarga       = $('#Suscriptores_'+i).attr('idCarga');
			   var fecha         = '01/'+ mes +'/'+ anio;
			   var idEmpresa     = $('#Suscriptores_'+i).attr('idEmpresa');
			    	   	 	   
			   if(idCarga == null || idCarga == "null")
			 	  idCarga = 0;
			 	   
			   var registro = {
			             mesActual : suscriptoresV,
				         idCarga   : idCarga,
				         fecha     : fecha,
				         idEmpresa : idEmpresa  			    
			   }
			   suscripciones[contador] = registro;
			   contador++;			   			   
		  }
	}
	   
	if(suscripciones.length > 0) 
	{
	    var json = JSON.stringify(suscripciones);
	    							    
	    $.post( contextPath + '/carga/suscripcion/actualizarSuscriptores', 
				{ request: json }
			  )
		 .done(function( response ) 
		  {
			 if(response.msgError != null)
			 {
				 showError(response.msgError);
				 $( "#gifLoad" ).hide();
			 }        		        			        		        	
	         else
	         {	        	
	        	limpiarTabla();	        	
	        	$( "#guardar" ).prop( "disabled", false );
	    		$( "#gifLoad" ).hide();
	        	showMessage("Los datos fueron guardados con \u00E9xito y se el calculo del costo de los t\u00EDtulos ha sido generado.");
	        	var fecha =  $('#fecha').val().split("/");
	        	
	     	    cargarInformacion(parseInt(fecha[0]), parseInt(fecha[2]));
	     	   $( "#guardar" ).prop( "disabled", true );
	         }
		  });		    		
	}
	else
	{
		$( "#guardar" ).prop( "disabled", false );
		$( "#gifLoad" ).hide();
		showWarn("No se ha realizado ninguna modificaci\u00F3n");
	}
				
}

function validarFecha(fecha){
	var validacion = true;
	try {
        $.datepicker.parseDate('mm/dd/yy', fecha);
    } catch (e) {
    	validacion = false;
    };
    return validacion;
}

function addCommas(nStr)
{
	nStr += '';
	x = nStr.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? '.' + x[1] : '';
	var rgx = /(\d+)(\d{3})/;
	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + ',' + '$2');
	}
	return x1 + x2;
}

function validarMonto(id){
	var valor = $("#Suscriptores_"+id).val().replace(" ", "");
	$("#Suscriptores_"+id).val(addCommas(valor));
}

function sumar(){
			 	
	var total=0;
	//TODO: PONER AQUI EL CODIGO PARA LOS MONTOS
	 $( "input.actual" ).each(function() {
	      total+=unFormat($( this ).val().replace(" ", ""));
	 });
	 this.totalActual=formatMiles(total);
	 $("#total").html(this.totalActual);
}

function addCommas(nStr)
{
	nStr += '';
	x = nStr.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? '.' + x[1] : '';
	var rgx = /(\d+)(\d{3})/;
	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + ',' + '$2');
	}
	return x1 + x2;
}