$(document).ready(function(){	
	if( $("#idContrato").attr("value") != "" )
	{		
		inicializarElementos();
		inicializarBotones();	
	}
	else{
	   showError('No ha sido seleccionado ning\u00FAn contrato.');
	   $("#idForm").hide();
	   $(".form-group").hide();
	}
});
	
function inicializarElementos(){
	  //Se trae las justificaciones que existan.
	  if($("#listJust").val() == null) 
	  {		  
		  $.post( contextPath + '/contrato/minimum/index.action', 
				  { idContrato : $("#idContrato").val() }
			    )
		   .done(function( response ) 
		   {
			   if(response.msgError != null){
	      		  showError(response.msgError);
	      	   }	      	   	         
		  });  
	  }
	  else
	  {
		  $.post( contextPath + '/contrato/minimum/getInfoMinimums.action', 
				  { idContrato : $("#idContrato").val() }
			    )
		   .done(function( response ) 
		   {
			   if(response.msgError != null){
	      		  showError(response.msgError);
	      	   }
	      	   else
	      	   {	      		   
	      		   limpiarTabla();
		           var releases = [];		        	
		           for(var i=0; i < response.releasses.length; i++)       		 
		        	   releases[i] = response.releasses[i].descripcion;	        		 	        	 		        	        	 
		           crearTablaDatos(releases, response.listado);		             
	      	   }	         
		  });		    
	  }	  	
}

function inicializarBotones(){
	
	$("#guardar").click(function()  
	{
	   var listado = [];
	   var i = 0;
	   var exitoso = 1;
	   
	   $('#TablaMinimun tbody td').each(function() {

		   if( $(this).attr("id") != null && $(this).text() != "" &&  $(this).text() != $(this).attr("valor"))
		   {			   
			   var valor = $(this).text();		    			                    		      		    		
		       if( validarSiNumero(valor) == 1)
		       {
			   	  var id    = $(this).attr("id").split("-");			    					    		
			      var minimum = {
			    			 idContrato	: id[0],
			    			 idPais     : id[1],
			    			 idRealese  : id[2],
			    			 idFormato  : id[3],
			    			 idMinimun  : id[4],
			    			 monto    	: valor		     			    		           			  
			   	  }    	   
			      listado[i] = minimum;
			      i++;			   			   
		       }
		       else 
		       {   exitoso = 0;		    	   
				   showError('Los datos deben ser n\u00FAmericos.');   
		       }
		   }		   
	   });
		    
	   if(exitoso == 1 && listado.length > 0)
	   {		   	   
		  var json  = JSON.stringify(listado);		    	
		  $.post( contextPath + '/contrato/minimum/actualizar.action', 
					{ requestJson: json, justificacion : $("#justificacion").val(), idContrato : $("#idContrato").val() }
				)
		   .done(function( response ) 
		   {
				 if(response.msgError != null)        		        		
		        	showError(response.msgError);	        	
		         else
		         {		
		         	  var urlAction = contextPath + '/contrato/minimum/index.action?idContrato=' + $("#idContrato").val();	       	   
		         	  window.location.href = urlAction;    	    	       	          	                     	   		        	 	
		         }		       		            		         
		  });		  		  
	  }	
	  else 
	  {
		 if(exitoso == 1)
			 showWarn("No existen cambios a guardar.");		 
	  }
	   
   });
	   
}

function validarSiNumero(numero){
    if (!/^([0-9])*$/.test(numero))
      return 0;
    return 1;
}

function crearTablaDatos(releasses, informacion){
	  
	  var idTable = "TablaMinimun";	 
	  var tablaMinimun = creaTabla( $( '#divTablaMin' ), idTable);
		  	  	 
	  var  filaTh   = $("<tr class='encabezado'/>");	  
	  for(var j=0; j < releasses.length; j++)
	  {
		  if(j == 0){  		
			  filaTh.append($("<th/>").text(releasses[j]));			  
		  }
		  else{		  			  
			  filaTh.append($("<th/>").text(releasses[j]).attr("colspan", "3").attr("style","text-align:center; border='2'"));			  
		  }
	  }
	  
	  tablaMinimun.find("thead").append(filaTh);	  	  

	  for (var i=0; i<informacion.length; i++)
	  {		
		  var fila = $("<tr/>");
		  
		  if(i == 0) 
			 var fila = $("<tr class='encabezado'/>");		  
		  
		  fila.append($("<td/>").text(informacion[i].pais));
		  
		  for (var j=0; j<informacion[i].valores.length; j++)
		  {					  			  			  			  
			  if(informacion[i].idRegistro != null)				  
				 fila.append($("<td />").text(informacion[i].valores[j]).attr("id",informacion[i].idRegistro[j]).attr("contenteditable","true").attr("valor", informacion[i].valores[j]));	
			  else				  			  
			     fila.append($("<td />").text(informacion[i].valores[j] ));
		  }		  		  		  
		  		  
		  $('#TablaMinimun tbody:last').append(fila);
	  }	    		 	  
}

function creaTabla(container, id) 
{	
    var table = $("<table border='1' class='table'/>").attr('id',id);       
    table.append($("<thead/>"));
    table.append($("<tbody/>"));   
    return container.append(table);
}

function limpiarTabla(){
	$('#divTablaMin').empty();
	$('#TablaMinimun').remove();		
}
