var reporteAcumulateBuysController = function($scope, $filter, $http, reporteAcumulateBuysService) {

	$scope.estudios = '';
	$scope.reporte = '';
	$scope.header = '';
	$scope.user = '';
	$scope.type = '';
	$scope.fechaInicio = '';
	$scope.fechaFin = '';
	var fecha = new Date();
	var anioActual = fecha.getFullYear();
	var mes = fecha.getMonth(); // numera los meses de 0 al 11
	var fechaPicker = mes + "/" + anioActual;


	$('#fechaInicio').datepicker({ dateFormat: 'mm/yy' }).datepicker("setDate", "-12m");
	$('#fechaFin').datepicker({ dateFormat: 'mm/yy' }).datepicker("setDate", "-1m");

	$scope.listarEstudios = function() {
		reporteAcumulateBuysService.obtenerEstudios().then(function(data) {

			$scope.estudios = data.estudios;
		});

	}

	$scope.listarEstudiosConfigurados = function() {
		reporteAcumulateBuysService.obtenerEstudiosConfig().then(function(data) {
			if (data.estudios != null && data.estudios.length != 0) {
				$scope.estudios = data.estudios;
			} else {
				$scope.listarEstudios();
			}

		});

	}

	$scope.origen = "AcumulateBuys";
	$scope.reporteAcumulateBuys = function() {

		if ($scope.origenReporte == undefined) {
		} else {
			$scope.origen = $scope.origenReporte;
		}

		$scope.type = $("#type").val();
		$scope.fechaInicio = $("#fechaInicio").val();
		$scope.fechaFin = $("#fechaFin").val();

		if ($scope.estudioSeleccionado != null) {
			reporteAcumulateBuysService.reporteAcumulateBuys($scope.origen, $scope.estudioSeleccionado.id_estudio, $scope.type, $scope.fechaInicio, $scope.fechaFin).then(function(data) {
				$scope.header = data.header;
				$scope.reporte = data.repporteacumulatebuys;
			});
		} else {
			swal("Selecciona un Estudio.");
		}

	}

	$scope.descargaExcel = function() {
		var url = contextPath + '/reporte/acumulatebuys/generaExcelAcumulateBuys.action?origen=' + $scope.origen + "&id_estudio=" + $scope.estudioSeleccionado.id_estudio + "&typeAbono=" + $scope.type + "&fechaInicio=" + $scope.fechaInicio + "&fechaFin=" + $scope.fechaFin;
		try { window.open(url); }
		catch (e) { showError("Ha ocurrid\u00F3 un error en la descarga: " + e.description); }
	}

	//se recuperan estudios al cargar controller
	$scope.listarEstudiosConfigurados();


	$scope.setFormat = function(row, column, x, y, tlength) {

		var styles = {};

		if ((x + 1) == tlength) {
			styles['font-weight'] = "bold";
			styles['text-align'] = "right";
		}
		else if (y == 0) {
			styles['width'] = "128px";
		}
		else
			styles['text-align'] = "right";
		return styles;
	}

	$scope.fmaFront = function(fecha) {
		return fecha != null ? fechaMesAnnio(fecha) : "";
	}

	$scope.printReport = function() {

		if ($scope.origenReporte == undefined) {
			$('#TableDiv').printThis({
				importCSS: true,
				importStyle: true,
				header: "<h3 style='width: 950px; font-weight:bold;'><img style='padding-right: 50px;' src='" + contextPath + "/design/img/common/Clarovideo.png'/>REPORTE ACUMULATE BUYS  " + $scope.fechaInicio + " - " + $scope.fechaFin + "</h3>"

			});

		} else {
			$('#TableDiv').printThis({
				importCSS: true,
				importStyle: true,
				header: "<h3 style='width: 1200px; font-weight:bold;'><img style='padding-right: 10px;' src='" + contextPath + "/design/img/common/Clarovideo.png'/>VISTA PREVIA REPORTE ACUMULATE BUYS  " + $scope.fechaInicio + " - " + $scope.fechaFin + "</h3>"

			});

		}

	}


	function fechaMesAnnio(fecha) {
		var fsplited = fecha.split("/");
		if (fsplited.length == 3)
			return getMesStr(fsplited[0]) + " " + fsplited[2];
		else
			return fecha;
	}

	function getMesStr(mes) {
		var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
		return meses[parseInt(mes) - 1];
	}


};

registraController("reporteAcumulateBuysController", reporteAcumulateBuysController);