package com.mx.dla.dda.admin.catalogos.transacciones.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.admin.catalogos.transacciones.dtos.CategoriasDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ConfiguracionesDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ExcepcionesTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ReporteGeneralDTO;

public interface TransaccionesDAO {
	
	public List<ExcepcionesTransDTO>getExcepciones();
	
	public List<CategoriasDTO>getCategorias();
	
	public List<EstudiosTransDTO>getEstudiosTrans();
	
	public void agregarExcepcion(ExcepcionesTransDTO excepcion);

	public void agregarCategoria(CategoriasDTO categoria);

	public void agregarEstudioTrans(EstudiosTransDTO estudio);

	public void eliminarEstudio(EstudiosTransDTO estudio);
	
	public void eliminarEstudioByName(EstudiosTransDTO estudio);

	public void eliminarCategoria(CategoriasDTO categoria);

	public void eliminarExcepcion(ExcepcionesTransDTO excepcion);

	public CategoriasDTO getCategoriaById(@Param("idCategoria")String idCategoria);

	public void updateCategoria(CategoriasDTO categoria);

	public EstudiosTransDTO getEstudioTransById(@Param("idEstudio") String idEstudio);

	public void updateEstudioTrans(EstudiosTransDTO estudio);

	public ExcepcionesTransDTO getExcepcionesById(@Param("idExcepcion") String idExcepcion);

	public void updateExcepcion(ExcepcionesTransDTO excepcion);

	public List<ReporteGeneralDTO> reporteGeneral(@Param("anio") String anio, @Param("mes") String mes, @Param("estudio") String estudio);

	public ExcepcionesTransDTO validaExcepcionExistente(ExcepcionesTransDTO estudio);

	public void cerrarReporte(@Param("valor")String valor, @Param("tipo")String tipo);

	public void reabrirReporte(@Param("mes")String mes, @Param("anio")String anio);
	
	public ConfiguracionesDTO validaMesCerrado(ExcepcionesTransDTO estudio);

}
