package com.mx.dla.dda.contrato.generales.daos;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.generales.dtos.CambioEstatusDTO;
import com.mx.dla.dda.contrato.generales.dtos.ProcesoPendienteDTO;

public interface OpcionesContratoDAO {
	
	public void insertarCategoria(@Param("idContrato") Long idContrato, @Param("idCategoria") Long idCategoria);
	
	public Integer verificaPorcentajeTitulosEnServicio(@Param("idContrato") Long idContrato, @Param("idServicio") Long idServicio);
	
	public void insertarServicio(@Param("idContrato") Long idContrato, @Param("idServicio") Long idServicio);
	
	public void insertarTerritorio(@Param("idContrato") Long idContrato, @Param("idTerritorio") Long idTerritorio);
	
	public void insertarMedioEntrega(@Param("idContrato") Long idContrato, @Param("idMedioEntrega") Long idMedioEntrega);
	
	public void insertarFilial(@Param("idContrato") Long idContrato, @Param("idFilial") Long idFilial);
	
	public void insertarType(@Param("idContrato") Long idContrato, @Param("idType") Long idType);
	
	public void registraTipoAmortizacion(@Param("idContrato") Long idContrato, @Param("tipoAmortizacion") String tipoAmortizacion);
	
	public void eliminarCategorias(@Param("idContrato") Long idContrato);
	
	public void eliminarServicios(@Param("idContrato") Long idContrato);
	
	public void eliminarTerritorios(@Param("idContrato") Long idContrato);
	
	public void eliminarMediosEntrega(@Param("idContrato") Long idContrato);
	
	public void eliminarFiliales(@Param("idContrato") Long idContrato);
	
	public void eliminarTypes(@Param("idContrato") Long idContrato);
	
	public void eliminarContratoArea(@Param("idContrato") Long idContrato);
	
	public void actualizaTipoAmortizacion(@Param("idContrato") Long idContrato, @Param("tipoAmortizacion") String tipoAmortizacion);
	
	public void actualizaEstatus(@Param("idEstatus") Long idEstatus, @Param("idContrato") Long idContrato);
	
	public void registraCambioEstatus(CambioEstatusDTO cambioEStatus);
	
	public Date obtenerFechaAutorizacion(@Param("idContrato") Long idContrato);
	
	public void actualizaFechaAutorizacion(@Param("fechaAutorizacion") Date fechaAutorizacion , @Param("idContrato") Long idContrato);
	
	public void ponEnNullMesesPjeExclusivo(@Param("idContrato") Long idContrato);
	
	public Long obtenerIdPadreContrato(@Param("idContrato") Long idContrato);
	
	public Long obtenerEstatusPadreContrato(@Param("idContrato") Long idContrato);
	
	public void registraProcesoPendiente(ProcesoPendienteDTO procesoPendiente);
	
	public String obtenerValorAmortizable(@Param("idContrato") Long idContrato);
	
	public String obtenerNumeroContrato(@Param("idContrato") Long idContrato);
	
	public void llamarAjustaAddendum(Map<String, Object> params);
	
	public void llamarReportePagos(Map<String, Object> params);
	
	public void llamarAmortizacionInicial(Map<String, Object> params);
	
	public void llamarAmortizacionCpv(Map<String, Object> params);
	
	public List<Long> obtenerIdFacturas(@Param("fechaCancelacion") Date fechaCancelacion , @Param("idContrato") Long idContrato);
	
	public void eliminaDespuesFechaCancelacion(@Param("fechaCancelacion") Date fechaCancelacion , @Param("idContrato") Long idContrato);
	
	public void actualizafechaCancelacion(@Param("fechaCancelacion") Date fechaCancelacion , @Param("idContrato") Long idContrato);
	
	public void insertaTotalTitulos(@Param("idContrato") Long idContrato, @Param("totalTitulos") Integer totalTitulos);
	
	public Long validaTotalTitulos(@Param("idContrato") Long idContrato);
	
	public void actulizaTotalTitulos(@Param("idContrato") Long idContrato, @Param("totalTitulos") Integer totalTitulos);

	public void completaWorkflowContrato(@Param("idContrato") Long idContrato, @Param("expediente") String expediente);
}
