package com.mx.dla.dda.contrato.generales.daos;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.generales.dtos.AutorizadorDTO;
import com.mx.dla.dda.contrato.generales.dtos.CorreoExternoDTO;
import com.mx.dla.dda.contrato.generales.dtos.DetalleCorreoDTO;
import com.mx.dla.dda.contrato.generales.dtos.WFPasoDTO;
import com.mx.dla.dda.contrato.generales.dtos.WFSeguimientoDTO;

public interface ValidacionGeneralesDAO {
	
	public Double obtenCantidad(@Param("idContrato") Long idContrato);
	
	public String obtenIdProveedor(@Param("idEstudio") Long idEstudio);
	
	public void registraContratoSAP(@Param("idContrato") Long idContrato, @Param("anio") Long anio, @Param("posicion") String posicion, @Param("cantidad") String cantidad);
	
	public void actualizaContratoSAP(@Param("idContrato") Long idContrato, @Param("cantidad") String cantidad);
	
	public Double obtenMontoContratoSAP(@Param("idContrato") Long idContrato);
	
	public String obtenerIdSapEstudioContrato(@Param("idContrato") Long idContrato);
	
	public Integer contarDocumentosContrato(@Param("idContrato") Long idContrato);
	
	public Integer contarFilialesContrato(@Param("idContrato") Long idContrato);
	
	public Integer contarCondicionesPagoContrato(@Param("idContrato") Long idContrato);
	
	public String esContratoAmortizable(@Param("idContrato") Long idContrato);
	
	public Integer contarAmortizacionesContrato(@Param("idContrato") Long idContrato);
	
	public Integer contarTitulosActivosContrato(@Param("idContrato") Long idContrato);
	
	public Integer obtenerTotalTitulosEnTerminos(@Param("idContrato") Long idContrato);
	
	public Long obtenerApartadoContrato(@Param("idContrato") Long idContrato);
	
	public List<AutorizadorDTO> obtenerAutorizador(@Param("idMenu") Long idMenu, @Param("idArea") Long idArea);
	
	public List<AutorizadorDTO> obtenerTodosAreas();
	
	public List<CorreoExternoDTO> obtenerCorreoExterno(@Param("seccion") String seccion);
	
	public DetalleCorreoDTO obtenerDetalleParaCorreo(@Param("idContrato") Long idContrato);
	
	public Long obtenIdMenuParaAutorizarContrato(@Param("nombre") String nombre);
	
	public void registraAutorizacion(@Param("idContrato") Long idContrato, @Param("idAreaWF") Long idAreaWF, @Param("expediente") String expediente, @Param("fechaRegistro") Date fechaRegistro);
	
	public void eliminaAutorizacionRegistrada(@Param("idContrato") Long idContrato, @Param("idPaso") Integer idPaso);
	
	public String obtenerTipoFees(@Param("idContrato") Long idContrato);
	
	public Integer contarTerminosContrato(@Param("idContrato") Long idContrato);
	
	public String obtenerDescripcionEstudio(@Param("idEstudio") Long idEstudio);
	
	public Integer contarSinSubnumero(@Param("idContrato") Long idContrato);
	
	//funciones que se van agregar para el WF
	public void actualizaEstaAutorizado(@Param("idContrato") Long idContrato, @Param("idPasoWF") Integer idPasoWF);
	
	public void registraWFSeguimiento(WFSeguimientoDTO wfSeguimiento);
	
	public WFPasoDTO obtnerWFPaso(@Param("ordenPasoWF") Integer ordenPasoWF);
	
	public void registraPasoWF(@Param("idContrato") Long idContrato, @Param("idPasoWF") Integer idPasoWF, @Param("expediente") String expediente, @Param("fechaRegistro") Date fechaRegistro);
	
	public String obtenerIdSapApartado(@Param("idApartado") Long idApartado);

	public Integer ObtenerErroresCalculoMinimoGarantizado(@Param("idContrato") Long idContrato);
}
