package com.mx.dla.dda.contrato.promociones.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.promociones.dtos.EstudiosPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PaisesPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionTitulosDTO;
import com.mx.dla.dda.contrato.promociones.dtos.TitulosPromocionesDTO;

public interface PromocionesDAO {
	
	public List<PromocionDTO> obtenerPromociones();
	
	public List<PromocionDTO> obtenerPromocionesVigentes();
	
	public List<EstudiosPromocionesDTO> obtenerEstudios();
	
	public List<PaisesPromocionesDTO> obtenerPaises();
	
	public List<TitulosPromocionesDTO> obtenerTitulos(@Param("id_pais") Long id_pais,@Param("id_estudio") Long id_estudio);
	
	public List<TitulosPromocionesDTO> obtenerTitulosTodos(@Param("id_estudio") Long id_estudio);
	
	public List<PromocionTitulosDTO> obtenerTitulosPromocion(@Param("id_promocion") Long id_promocion);
	
	public void crearPromocion(PromocionDTO promocion);
	
	public void registraTitulosPromocion(PromocionTitulosDTO promociontitulos);
	
	public void actualizaPromocion(PromocionDTO promocion);
	
	public void eliminaPromocion(@Param("id_promocion") Long id_promocion);
	
	public void eliminaTitulosPromocion(@Param("id_promocion") Long id_promocion);

}
