package com.mx.dla.admin.usuarios.perfil.bos;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.admin.daos.UsuarioDAO;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.admin.usuarios.perfil.daos.UsuarioPerfilDAO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class UsuarioPerfilBO extends BaseBO{
	
	@Autowired
	private UsuarioDAO usuarioDAO;
	
	@Autowired
	private UsuarioPerfilDAO usuarioPerfilDAO;
	
	public UsuarioDTO obtenerUsuario(String expediente) throws ResultMapException, SQLException, TransaccionException {
		UsuarioDTO usuario = null;
		
		try{
			usuario = usuarioDAO.obtenerUsuario(expediente);
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }
		
		return usuario;
	}
	
	
	public boolean actulizaPropiedadUsuario(String expediente, String correo, String contrasena, String operacion) throws ResultMapException, SQLException, TransaccionException {
		
		if(operacion.equals("correo")){
			return actualizaCorreo(expediente, correo);
		}else {
			return actualizaContrasena(expediente, contrasena);
		}
	}
	
	public boolean actualizaCorreo(String expediente, String correo) throws ResultMapException, SQLException, TransaccionException {
		boolean exito = false;
		try {
			logger.debug("correo : [{}], expediente: [{}]", correo, expediente);
			usuarioPerfilDAO.actualizaCorreo(expediente, correo);
			exito = true;
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }
		
		return exito;
	}
	
	public boolean actualizaContrasena(String expediente, String contrasena) throws ResultMapException, SQLException, TransaccionException {
		boolean exito = false;
		String hexaRepre = null;
		try {
			hexaRepre = md5Hashing(contrasena);
			logger.info("contrasena hexa : [{}]", hexaRepre);
			usuarioPerfilDAO.actualizaContrasena(expediente, hexaRepre);
			exito = true;
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (NoSuchAlgorithmException e) {
        	throw new TransaccionException("El algoritmo ha codificado correctamente " + e);
		}
		
		return exito;
	}
	
	public String md5Hashing(String password) throws NoSuchAlgorithmException{
		
		MessageDigest md = MessageDigest.getInstance("MD5");
		md.update(password.getBytes());
		byte[] dataBytes = md.digest();
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < dataBytes.length; i++){
			sb.append(Integer.toString((dataBytes[i] & 0xff) + 0x100 , 16).substring(1));
		}
		
		return sb.toString();
	}

}
