package com.mx.dla.dda.reporte.amortizacion.presupuesto.bo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dao.ReporteAmortVsPptoDAO;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dto.ReporteAmortizacionVsPresupuestoDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class ReporteAmortvsPptoBO extends BaseBO {
	@Autowired
	private ReporteAmortVsPptoDAO reporAmortPptodao;
	
	@Autowired
	private ExcelMapperContext excelMapperContext;
	
	@Autowired
	protected ExcelMapperTransform excelMapperTransform;
	
	@Autowired
	private BeanPopulator beanPopulator;
	
	public List<ReporteAmortizacionVsPresupuestoDTO> obtenReporteAmortPpto(Long mes, Long annio) throws TransaccionException {

		List<ReporteAmortizacionVsPresupuestoDTO> reporteAmortPpto = null;

		try {
			
			reporteAmortPpto = reporAmortPptodao.obtenerReporteAmortPpto(mes,annio);
			
			logger.info("obtenReporteAmortPpto - [{}]",reporteAmortPpto);
			
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos.", e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos", e);
        }

		return reporteAmortPpto;
	}
	
	public byte [] descargaArchivoReporte(String mes) throws ExcelMapperException, IOException, TransaccionException{
		 List<ReporteAmortizacionVsPresupuestoDTO> rowReporte =  new ArrayList<ReporteAmortizacionVsPresupuestoDTO>();
		
		try{
			
			if(rowReporte == null || rowReporte.isEmpty())
			{
				rowReporte = new ArrayList<ReporteAmortizacionVsPresupuestoDTO>();
				rowReporte.add(beanPopulator.initObject(ReporteAmortizacionVsPresupuestoDTO.class));
			}			   											
			logger.info("Descargar archivo Reporte... se han  obtenido [{}]",rowReporte.size());
			
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos.", e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos", e);
        }
		
		byte[] fileExcel = excelMapperTransform.transformObjectToExcel(rowReporte,"reporteAmortizacion",ReporteAmortizacionVsPresupuestoDTO.class);
		logger.info("Descargar archivo, se ha generado binario.");
		
		return fileExcel;
	}
	
	public byte[] descargaObjReporte(List<ReporteAmortizacionVsPresupuestoDTO> inforowReporte) throws TransaccionException, ExcelMapperException, IOException{
		
		for(ReporteAmortizacionVsPresupuestoDTO c : inforowReporte){
			logger.debug("[{}]", c);
		}
		
		byte[] barchivo = null;
		ExcelMapper mapper = excelMapperContext.getExcelMapper("reporteAmortizacionPpto");
		
		try {
			
			barchivo = excelMapperTransform.transformObjectToExcel(inforowReporte, mapper, ReporteAmortizacionVsPresupuestoDTO.class);
			
		} catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos.", e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos", e);
        }
		
		return barchivo;		
		
	}

}
