package com.mx.dla.dda.contrato.transaccion.fees.actions;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.fees.bos.FeesTransaccioBO;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.global.dtos.FilaExcelDTO;

public class FeesCargaTAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private String msgError;
	private String msgExito;
	private String fileContentType;
	private String fileFileName;
	private String tipoFees;
	private String operacion;
	private File file;
	private Long idCto;

	private List<List<String>> datos;
	private List<String> encabezados;
	private List<FilaExcelDTO> datosMatriz;

	@Autowired
	private FeesTransaccioBO fees;

	public String cargaArchivo() throws TransaccionException {
		try {
			logger.info(tipoFees + ":" + operacion);
			logger.info("Type [{}] name [{}]", fileContentType, fileFileName);
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			this.datosMatriz = fees.obtenerDatosExcel(file, fileFileName, usuario.getExpediente(),
					(Long) this.getSession().get("idContrato"));
			logger.info("Se termina de cargar los datos de excel.");
		} catch (ExcelMapperException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public String descargar() throws TransaccionException {

		String nombre = null;
		byte[] result = null;
		try {
			result = fees.descargarArchivoExcel(tipoFees, operacion, this.datos, this.encabezados);
			nombre = fees.getNombreArchivo() + this.idCto;

			HttpServletResponse response = ServletActionContext.getResponse();
			response.setContentLength(result.length);
			response.setContentType(ContentType.EXCELX.name());
			response.setHeader("Content-Disposition", "attachment;filename=" + nombre + ".xlsx");

			logger.debug("" + result.length);
			ServletOutputStream out = response.getOutputStream();
			out.write(result);
			out.flush();
		} catch (IOException e) {
			logger.error("{}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("{}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return null;
	}

	public String getFileContentType() {
		return fileContentType;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public File getFile() {
		return file;
	}

	public String getMsgError() {
		return msgError;
	}

	public String getMsgExito() {
		return msgExito;
	}

	public void setMsgError(String msgError) {
		this.msgError = msgError;
	}

	public void setMsgExito(String msgExito) {
		this.msgExito = msgExito;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public String getTipoFees() {
		return tipoFees;
	}

	public void setTipoFees(String tipoFees) {
		this.tipoFees = tipoFees;
	}

	public String getOperacion() {
		return operacion;
	}

	public void setOperacion(String operacion) {
		this.operacion = operacion;
	}

	public void setIdCto(Long idCto) {
		this.idCto = idCto;
	}

	public void setDatos(List<List<String>> datos) {
		this.datos = datos;
	}

	public void setEncabezados(List<String> encabezados) {
		this.encabezados = encabezados;
	}

	public List<FilaExcelDTO> getDatosMatriz() {
		return datosMatriz;
	}

}
