package com.mx.dla.dda.contrato.transaccion.terminos.dtos;

public enum SeccionesTerminos {

	RentaPremium("RPM"), 
	RentaPremier("RPR"), 
	RentaLibreria("RLB"), 
	VentaMovies("VTM"), 
	VentaSeries("VTS"), ;

	private String desc;

	SeccionesTerminos( String desc) {		
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}
		
	public static String getSeccion(String id){
		SeccionesTerminos[] values = SeccionesTerminos.values();
		
		SeccionesTerminos target = null;
		for (SeccionesTerminos t : values) {
			if (t.getDesc().equals(id)) {
				target = t;
				break;
			}
		}
		return target.desc;
	}
	
}
