package com.mx.dla.dda.contrato.transaccion.titulos.actions;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranGridBO;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionDTO;

public class TituloGridTransAction extends BaseContratoAction {
	private static final long serialVersionUID = 8148896697230880220L;

	@Autowired
	private TituloTranGridBO tituloGridBO;

	private String titulo;
	private List<TituloTransaccionDTO> titulos;
	private String error;
	private String mensaje;
	private String ids;
	private String operacion;
	private Long idLista;
	private String idBv;
	private ObjectMapper mapper;

	public String agregarTitulo() {
		this.initMapper();
		try {
			logger.info("AgregarTitulo");
			Long idContrato = (Long) this.getSession().get("idContrato");
			this.mensaje = tituloGridBO.agregarTitulo(idContrato, this.idLista,
					mapper.readValue(this.titulo, TituloTransaccionDTO.class));
		} catch (TituloException e) {
			this.error = e.getMessage();
		} catch (JsonParseException e) {
			this.error = "Ha ocurrido un error al guardar el ttulo";
			logger.error("Error : {}", e);
		} catch (JsonMappingException e) {
			this.error = "Ha ocurrido un error al guardar el ttulo";
			logger.error("Error : {}", e);
		} catch (IOException e) {
			this.error = "Ha ocurrido un error al guardar el ttulo";
			logger.error("Error : {}", e);
		}
		return SUCCESS;
	}

	public String seriesAutomaticoTitulo() {
		this.initMapper();
		try {
			Long idContrato = (Long) this.getSession().get("idContrato");
			tituloGridBO.altaSeriesAuto(idContrato, this.idLista,
					mapper.readValue(this.titulo, TituloTransaccionDTO.class));

		} catch (TituloException e) {
			this.error = e.getMessage();
		} catch (JsonParseException e) {
			this.error = "Ha ocurrido un error al guardar el ttulo";
			logger.error("Error : {}", e);
		} catch (JsonMappingException e) {
			this.error = "Ha ocurrido un error al guardar el ttulo";
			logger.error("Error : {}", e);
		} catch (IOException e) {
			this.error = "Ha ocurrido un error al guardar el ttulo";
			logger.error("Error : {}", e);
		}
		return SUCCESS;
	}

	public String editarTitulo() {
		this.initMapper();
		try {
			logger.info("EditarTitulo");
			Long idContrato = (Long) this.getSession().get("idContrato");
			tituloGridBO.editarTitulo(idContrato, this.idLista,
					mapper.readValue(this.titulo, TituloTransaccionDTO.class));

		} catch (TituloException e) {
			this.error = e.getMessage();
		} catch (JsonParseException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al guardar el ttulo";
		} catch (JsonMappingException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al guardar el ttulo";
		} catch (IOException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al guardar el ttulo";
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al guardar el ttulo";
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al guardar el ttulo";
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al guardar el ttulo";
		}
		return SUCCESS;
	}

	public String eliminarTitulo() {
		this.initMapper();
		try {
			tituloGridBO.eliminarTitulo(mapper.readValue(this.titulo, TituloTransaccionDTO.class).getIdTituloCnt());
		} catch (JsonParseException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al eliminar el titulo.";
		} catch (JsonMappingException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al eliminar el titulo.";
		} catch (IOException e) {
			logger.error("Error : {}", e);
			this.error = "Ha ocurrido un error al eliminar el titulo.";
		}

		return SUCCESS;
	}

	public String cambioMultipleTitulo() {
		this.initMapper();
		try {
			Long idContrato = (Long) this.getSession().get("idContrato");
			List<Long> datos = mapper.readValue(ids, new TypeReference<List<Long>>() {
			});
			TituloTransaccionDTO t = mapper.readValue(this.titulo, TituloTransaccionDTO.class);
			this.mensaje = tituloGridBO.cambioMultipleTitulo(idContrato, this.idLista, t, datos, this.operacion);
		} catch (TituloException e) {
			this.error = e.getMessage();
		} catch (JsonParseException e) {
			logger.error("Error : {}", e);
			this.error = "Se ha generado un error al guardar los datos.";
		} catch (JsonMappingException e) {
			logger.error("Error : {}", e);
			this.error = "Se ha generado un error al guardar los datos.";
		} catch (IOException e) {
			logger.error("Error : {}", e);
			this.error = "Se ha generado un error al guardar los datos.";
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			this.error = "Se ha generado un error al guardar los datos.";
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			this.error = "Se ha generado un error al guardar los datos.";
		}
		return SUCCESS;
	}

	public String obtenerTitulos() {

		try {
			this.titulos = tituloGridBO.obtenerTitulos(Lista.MIRROR, this.idLista);
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	public String obtenerTitulosSeries() {
		try {
			this.titulos = tituloGridBO.obtenerTitulosSeries(Lista.MIRROR, this.idLista, this.titulo);
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	public String listarPrincipalTitulos() {
		try {
			this.titulos = tituloGridBO.listarPrincipalTitulos(Lista.MIRROR, this.idLista);
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	public String listarSeriesTitulos() {
		try {
			this.titulos = tituloGridBO.listarSeriesTitulos(Lista.MIRROR, this.idLista, this.titulo);
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	public String listarDetalleTitulos() {
		try {
			this.titulos = tituloGridBO.listarDetalleTitulos(Lista.MIRROR, this.idLista, this.titulo, this.idBv);
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	public String listarTitulosEnLista() {
		try {
			this.titulos = tituloGridBO.titulosEnLista(this.idLista, Lista.REAL);
		} catch (ResultMapException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (SQLException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		} catch (TransaccionException e) {
			logger.error("Error : {}", e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}

	private void initMapper() {
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		mapper = new ObjectMapper();
		mapper.setDateFormat(df);
	}

	public String getTitulo() {
		return titulo;
	}

	public String getError() {
		return error;
	}

	public String getMensaje() {
		return mensaje;
	}

	public List<TituloTransaccionDTO> getTitulos() {
		return titulos;
	}

	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public void setOperacion(String operacion) {
		this.operacion = operacion;
	}

	public void setIdLista(Long idLista) {
		this.idLista = idLista;
	}

	public void setError(String error) {
		this.error = error;
	}

	public String getIdBv() {
		return idBv;
	}

	public void setIdBv(String idBv) {
		this.idBv = idBv;
	}

}
