var numFilaPago = -1;
var terminos;
var service;

$(document).ready(function(){    
    //Se iniciliazan elementos
	bindingInputValores("tAnticipado");
	terminos = new Termino();
	service  = new TerminoService();
	service.obtenerTerminos();	
	
	$("#costoContrato").change(function() {			
		if($(this).val() != "")
		{
			var valor = deleteCommas($(this).val());    				
			if(isNaN(valor))
			{
				showError("El valor ingresado no es un n\u00FAmero.");
				$(this).val("");
			}
			else if(parseFloat(valor) < 0)
			{
				showError("El valor ingresado debe ser mayor a cero.");
				$(this).val("");
			}
			else
			{
				$(this).val(parseFloat(valor).formatDLA());
				terminos.costoContrato = valor;
								
				var numPagos = $("#tPeriodicos tbody tr").length;
				var valPagos = valor / numPagos;
				
				$("#tPeriodicos tbody tr").each(function(){					
					$(this).find("td:first input").val(parseFloat(valPagos).formatDLA());
				});
				calcularMontoPrograPendien();
			}				
		}
	});			
});

function registrarDatosContrato(contrato, termino){	
	if(termino.costoContrato  != null && 
	  (termino.pagoAnticipado != null || (termino.pagoPeriodicos != null && termino.pagoPeriodicos.length > 0) ))
	{
		var costo = service.obtenerMontoProgramado(termino);
		var pendiente = Math.trunc(parseFloat(termino.costoContrato) - costo);
		$("#montoProgramado").val(costo.formatDLA());
		$("#montoPendiente").val(pendiente.formatDLA());			
	}	
							
	var costoCto   = termino.costoContrato   == null ? "" : termino.costoContrato.formatDLA();
	var costoMat   = termino.costoMateriales == null ? "" : termino.costoContrato.formatDLA();
	var numTitulos = termino.numeroTitulos   == null ? "" : termino.numeroTitulos; 
	$("#costoContrato")  .val(costoCto);
	$("#numTitulos")     .val(numTitulos);
	$("#costoMateriales").val(costoMat);	
	$("#tipoCto")        .val(contrato.idTipoContrato);
	$("#fechaInicioCto") .val(contrato.fechaInicio);		
}

function registrarDatosTermino(termino){
	
	var fechIniCto = $("#fechaInicioCto").val().substring(0, 10).split("-");
	fechIniCto = crearFecha(fechIniCto[1]+"/"+fechIniCto[2]+"/"+fechIniCto[0]);	
	
	if(!termino.vacio)
	{		
		if(termino.pagoAnticipado != null)
		{
			var inputs = $("#tAnticipado tbody tr:first").find("td input[type='text']");						 		
			inputs[0].value = termino.pagoAnticipado.monto.formatDLA();
			inputs[1].value = termino.pagoAnticipado.fecha;
			inputs[2].value = termino.pagoAnticipado.descripcion;			
			$("input[id='cbanticipo']").prop('checked', 'true');
			mostrarAnticipo();				
			
			if( parseInt($("#tipoCto").val()) > 1 && verificarFecha1menFecha2(crearFecha($("#antFecha").val()), fechIniCto) )
			{
				$("#antFecha").datepicker("destroy");
				$("#antFecha").removeClass("hasDatepicker");
				$("#antFecha")     .attr("readOnly", "");
				$("#antMonto")     .attr("readOnly", "");
				$("#antComentario").attr("readOnly", "");				
			}
		}
		
		if(termino.pagoMensual != null && termino.pagoMensual)
		{
			$("input[id='rbPagoMensual']").prop('checked', 'true');
		}

		if(termino.pagoInicioExhibicion != null && termino.pagoInicioExhibicion)
		{									
			$("input[id='rbPagoDefinido']").prop('checked', 'true');			
			$("input[id='rbPagoInicio']").prop('checked', 'true');
			mostrarPagoDefinido();
		}
		
		if(termino.pagoPeriodicos != null && termino.pagoPeriodicos.length > 0)
		{			
			$("input[id='rbPagoDefinido']").prop('checked', 'true');			
			$("input[id='rbPeriodico']").prop('checked', 'true');
			
			for(var i=0; i<termino.pagoPeriodicos.length; i++)
			{				
				var editable = true;
				if(parseInt($("#tipoCto").val()) > 1 && verificarFecha1menFecha2(crearFecha(termino.pagoPeriodicos[i].fecha), fechIniCto) )				
					editable = false;
				agregarFilaPagoDatos(termino.pagoPeriodicos[i].monto.formatDLA(), termino.pagoPeriodicos[i].fecha, termino.pagoPeriodicos[i].descripcion, editable);
			}							
			removerDateInputs();
			mostrarPagoDefinido();
			mostrarPagoPeriodico();												
		}
				
		$("#comment").val(termino.comentario);
	}				
}

function limpiarForma(){
	
	$("table input").each(function(){					
		$(this).val("");
	});
	
	$("#cbanticipo")    .prop('checked', false);
	$("#rbPagoMensual") .prop('checked', false);
	$("#rbPagoDefinido").prop('checked', false);
	$("#rbPagoInicio")  .prop('checked', false);
	$("#rbPeriodico")   .prop('checked', false);
			
	$("#tPeriodicos tbody tr").each(function(){					
		$(this).remove();
	});		
	
	$("#txtPago").val("");
	$("#txtFechaInicio").val("");		
}

function mostrarAnticipo(){		
	if($("input[id='cbanticipo']").prop('checked'))
	{
	    $("#btnConfig").hide();
	    $("#divAnticipo").show();
	}		
	else
		$("#divAnticipo").hide();
}

function mostrarPagoDefinido(){			
	if($("input[id='rbPagoDefinido']").prop('checked'))
	{		
		if($("input[id='rbPeriodico']").prop('checked'))
		{
			if($("#tPeriodicos tbody tr").length == 0)
			   $("#btnConfig").show();
			else
			   $("#btnConfig").hide();
		}
		$("#divPredefinido").show();
	}		
	else
		$("#divPredefinido").hide();
}

function mostrarPagoPeriodico(){	
	if($("input[id='rbPeriodico']").prop('checked'))
	{
		if($("#tPeriodicos tbody tr").length == 0)
		   $("#btnConfig").show();
		else
		   $("#btnConfig").hide();
		$("#divPeriodico").show();
	}		
	else
		$("#divPeriodico").hide();
	
	if($("input[id='rbPagoInicio']").prop('checked'))
		$("#btnConfig").hide();
}

function generarPeriodos(){
	$("#labErrAddPer").hide();
	
	if($("#txtPago").val() == "" || $("#txtFechaInicio").val() == "")
	   $("#labErrAddPer").text("Registrar todos los campos.").show();
	else if(isNaN($("#txtPago").val()))
		$("#labErrAddPer").text("El campo n\u00FAmero de pagos deber ser un n\u00FAmero v\u00E1lido.").show();
	else if(parseFloat($("#txtPago").val()) < 0)
		$("#labErrAddPer").text("El campo n\u00FAmero de pagos deber ser mayor a cero.").show();
	else
	{
		var numPagos = parseInt($("#txtPago").val());
		var mesesInc = parseInt($("#selPeriodo").val());
		var anticipo = 0.0;
		var costoCto = parseFloat(deleteCommas($("#costoContrato").val()));
		
		if($("input[id='cbanticipo']").prop('checked') && $("#antMonto").val() != "")
		   anticipo = $("#antMonto").val() != "" ? parseFloat(deleteCommas($("#antMonto").val())) : 0.0;
		   
		var monto = (costoCto - anticipo) / numPagos;
		var resto = costoCto - ((monto*numPagos) + anticipo);
		
		for(var i =0; i<numPagos; i++)
		{
			var fecha = new Date($("#txtFechaInicio").val().split("/")[2], parseInt($("#txtFechaInicio").val().split("/")[0])-1, $("#txtFechaInicio").val().split("/")[1]);
			var fechaper = crearFechaString(fecha, mesesInc * i);			
			agregarFilaPagoDatos(monto.formatDLA(), fechaper, "", true);	
		}		
		mostrarPagoDefinido();
		mostrarPagoPeriodico();
	}
	
	calcularMontoPrograPendien();
	$("#divConfig").modal("hide");
}

function verificarFecha1menFecha2(fecha1, fecha2){	
	if(fecha1.getTime() < fecha2.getTime())
		return true;
	else
		return false;
}

function crearFecha(fecha){
	return new Date(fecha.split("/")[2], parseInt(fecha.split("/")[0])-1, fecha.split("/")[1]);
}

function crearFechaString(fecha, meses){	
	var nuFecha = new Date(fecha.setMonth(fecha.getMonth()+meses));
	var mes = (nuFecha.getMonth()+1) < 10 ? "0"+(nuFecha.getMonth()+1): (nuFecha.getMonth()+1);
	var dia = nuFecha.getDate() < 10 ? "0"+nuFecha.getDate() : nuFecha.getDate();
	var nfecha = mes + "/" + dia + "/"+ nuFecha.getFullYear();	
	return nfecha;
}

function agregarFilaPago(){		
	var tr = $("<tr id='"+numFilaPago+"'/>").append($("<td/>").append($("<input type='text'/>")))
				                            .append($("<td/>").append($("<input type='text'/>")))
				                            .append($("<td/>").append($("<input type='text'/>")));	
	tr.append($("<td/>").append("<label><span data-toggle='tooltip' title='Eliminar Pago'  onclick='eliminarFilaPago("+numFilaPago+")'  class='ui-icon ui-icon-close'></span></label>"))
	$("#tPeriodicos tbody").append(tr);
	numFilaPago--;	
	bindingInputValores("tPeriodicos");
		
	if($("#tPeriodicos tbody tr").length == 0)
	   $("#btnConfig").show();
	else
	   $("#btnConfig").hide();
}

function agregarFilaPagoDatos(monto, fecha, descripcion, visible){
	var str = "";
	if(!visible)
		str = "readonly";	
	
	descripcion = descripcion == null ? "" : descripcion;
	var tr = $("<tr id='"+numFilaPago+"'/>").append($("<td/>").append($("<input type='text' value='"+ monto +"' "+str+" />")))
				                            .append($("<td/>").append($("<input type='text' value='"+ fecha +"' "+str+" />")))
				                            .append($("<td/>").append($("<input type='text' value='"+ descripcion +"' "+str+" />")));
	
	if(visible)
		tr.append($("<td/>").append("<label><span data-toggle='tooltip' title='Eliminar Pago'  onclick='eliminarFilaPago("+numFilaPago+")'  class='ui-icon ui-icon-close'></span></label>"))
	else
		tr.append($("<td/>"));
	
	$("#tPeriodicos tbody").append(tr);
	numFilaPago--;	
	bindingInputValores("tPeriodicos");
}

function eliminarFilaPago(id){
	$("#tPeriodicos").find("tr[id='"+id+"']").remove();
	
	if($("#tPeriodicos tbody tr").length == 0)
	   $("#btnConfig").show();
	else
	   $("#btnConfig").hide();
}

function removerDateInputs(){
	$("#tPeriodicos").find("input[readOnly]").each(function(){					
		if ( $(this).hasClass( "hasDatepicker" ) ) 
		{
			$(this).datepicker("destroy");
			$(this).removeClass("hasDatepicker");
		}		
	});
}

function bindingInputValores(idTabla){	
	$("#"+idTabla+" tr").each(function(){
		
		$(this).find("td:nth-child(1)").find("input").change(function() {			
			if($(this).val() != "")
			{
				var valor = deleteCommas($(this).val());    				
				if(isNaN(valor))
				{
					showError("El valor ingresado no es un n\u00FAmero.");
					$(this).val("");
				}
				else if(parseFloat(valor) < 0)
				{
					showError("El valor ingresado debe ser mayor a cero.");
					$(this).val("");
				}
				else
					$(this).val(parseFloat(valor).formatDLA());
			}
		});    	
			
		$(this).find("td:nth-child(1)").find("input").change(function() {
			calcularMontoPrograPendien();
		});
		$(this).find("td:nth-child(2)").find("input").datepicker();				
	});
}

function guardarTermino(){	
	obtenerTerminos();		
	var costo     = service.obtenerMontoProgramado(terminos);
	var resultado = service.validarTermino(terminos, costo);	

	if(!resultado.valido)
	   showError(resultado.mensaje);
	else
	service.guardarTerminos(terminos);		
}

function calcularMontoPrograPendien(){	
	obtenerTerminos();		
	var costo = service.obtenerMontoProgramado(terminos);
	var pendiente = parseFloat(terminos.costoContrato) - costo;	
	$("#montoProgramado").val(costo.formatDLA());
	$("#montoPendiente").val(pendiente.formatDLA());
}

function obtenerTerminos(){
			
	terminos.costoContrato   = deleteCommas($("#costoContrato")  .val());
	terminos.costoMateriales = deleteCommas($("#costoMateriales").val());
    terminos.numeroTitulos   = deleteCommas($("#numTitulos")  .val());
    
	if($("input[id='cbanticipo']").prop('checked'))
	   terminos.pagoAnticipado = obtenerPagos("tAnticipado")[0];
	else
	   terminos.pagoAnticipado = null;
	
	if($("input[id='rbPagoMensual']").prop('checked'))
	{
		terminos.pagoMensual          = true;
		terminos.pagoInicioExhibicion = false;
		terminos.pagoPeriodicos       = null;
	}	   	
	else if(!$("input[id='rbPagoMensual']").prop('checked') && $("input[id='rbPagoInicio']").prop('checked'))
	{
		terminos.pagoMensual          = false;
		terminos.pagoInicioExhibicion = true;
		terminos.pagoPeriodicos       = null;
	}					
	else if(!$("input[id='rbPagoMensual']").prop('checked') && $("input[id='rbPeriodico']").prop('checked'))
	{
		terminos.pagoMensual          = false;
		terminos.pagoPeriodicos = obtenerPagos("tPeriodicos");
		terminos.pagoInicioExhibicion = false;
	}	   
    
	terminos.comentario    = $("#comment").val(); 			
}

function obtenerPagos(idTabla){
	var pagos = [];
	$("#"+ idTabla + " tbody tr").each(function(){				
		var inputs = $(this).find("td input[type='text']");
		var pago = new PagoTermino();
		pago.monto       = deleteCommas(inputs[0].value);
		pago.fecha       = inputs[1].value;
		pago.descripcion = encodeURIComponent(inputs[2].value);
		pagos.push(pago);
	});
	return pagos;
}

function deshabilitarForma(){		
	$('form input')   .prop( "disabled", true);
	$('form button')  .prop( "disabled", true);
	$('#comment').prop( "disabled", true);		
}

function deleteCommas(valor){ return (valor.replaceAll(",","")).replace(/^0+/, ''); }

String.prototype.replaceAll = function(target, replacement) {
	  return this.split(target).join(replacement);
};

function formatCurrency(unformatedCurrency, n, x) {
	var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
	return unformatedCurrency.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,');
};

function unformatCurrency(formatedCurrency) {
	return String(formatedCurrency).replace(/ /g, "").replace(/,/g, "").replace("$", "");
};

function validateCurrency(currencyString, decimales) {
	var currency_regex = /(?=.)^\$?(([1-9][0-9]{0,2}(,[0-9]{3})*)|[0-9]+)?(\.[0-9]{1,4})?$/;
	return currency_regex.test(currencyString);
}

Number.prototype.round = function(places) {
	  return +(Math.round(this + "e+" + places)  + "e-" + places);
}

function unformatCurrency(formatedCurrency) {
	return String(formatedCurrency).replace(/ /g, "").replace(/,/g, "").replace("$", "");
};