package com.mx.dla.dda.contrato.fees.bos;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.CategoriaFeesDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class FeesCategoriaBO extends BaseBO{

	@Autowired
	private FeesContratoDAO feesContratoDAO;

	@Autowired
	private MinimoSeleccionBO minimoSeleccionBO;
	
	public void guardarCategorias(List<FeesContratoPagoDTO> periodos, Long idContrato) throws UnsupportedEncodingException{				
		if(periodos.get(0).getTipoPago().compareTo("ESCALA") == 0)
		{
			for(int i=0; i<periodos.get(0).getCategorias().size(); i++)
			{									
				CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(periodos.get(0).getCategorias().get(i).getDescCategoria(), "UTF-8"));						
				feesContratoDAO.guardarCategoria(categoria, idContrato);
				for(int j=0; j<periodos.size(); j++)			
					periodos.get(j).getCategorias().get(i).setIdCategoria(categoria.getIdCategoria());			
			}
		}
		
		else if(periodos.get(0).getTipoPago().compareTo("FLAT") == 0)
		{			
			for(int i=0; i<periodos.get(0).getFlats().size(); i++)
			{			
				CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(periodos.get(0).getFlats().get(i).getDescCategoria(), "UTF-8"));
				feesContratoDAO.guardarCategoria(categoria, idContrato);				
				for(int j=0; j<periodos.size(); j++)			
					periodos.get(j).getFlats().get(i).setIdCategoria(categoria.getIdCategoria());			
			}	
		}		
	}
	
	public void editarCategorias(List<FeesContratoPagoDTO> periodos, Long idContrato) throws UnsupportedEncodingException{
		if(periodos.get(0).getTipoPago().compareTo("ESCALA") == 0)
		{
			for(int i=0; i<periodos.get(0).getCategorias().size(); i++)
			{									
				CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(periodos.get(0).getCategorias().get(i).getDescCategoria(), "UTF-8"));
				categoria.setIdCategoria(periodos.get(0).getCategorias().get(i).getIdCategoria());
				if(periodos.get(0).getCategorias().get(i).getIdCategoria() <= 0)
				{
					feesContratoDAO.guardarCategoria(categoria, idContrato);
														
					for(int j=0; j<periodos.size(); j++)
					{
						periodos.get(j).getCategorias().get(i).setIdCategoria(categoria.getIdCategoria());
						
						if(periodos.get(j).getIdContratoPago() > 0)    //edita periodos guardados los nuevos se guardaran mas adelate
						{
							//Se agrega el minimo de seleccion por cateoria nueeva
							minimoSeleccionBO.guardarMinSeleccion(periodos.get(j).getIdContratoPago(), categoria.getIdCategoria(), null);							
							
							//Se actualiza los rangos existentes para la nueva categoria
							for(int r=0; r < periodos.get(j).getCategorias().get(i).getRangos().size(); r++)
							{
								if(periodos.get(j).getCategorias().get(i).getRangos().get(r).getIdRango() > 0)
								   feesContratoDAO.guardarPagoCosto(periodos.get(j).getCategorias().get(i).getRangos().get(r).getIdRango(), 
										                            periodos.get(j).getCategorias().get(i).getRangos().get(r).getMonto(), 
										                            categoria.getIdCategoria());							
							}
						}												
					}															
				}				   
				else
				   feesContratoDAO.actualizarCategoria(categoria);						
			}
		}
		
		else if(periodos.get(0).getTipoPago().compareTo("FLAT") == 0)
		{			
			for(int i=0; i<periodos.get(0).getFlats().size(); i++)
			{			
				CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(periodos.get(0).getFlats().get(i).getDescCategoria(), "UTF-8"));
				categoria.setIdCategoria(periodos.get(0).getFlats().get(i).getIdCategoria());
				if(periodos.get(0).getFlats().get(i).getIdCategoria() <= 0)
				{
					feesContratoDAO.guardarCategoria(categoria, idContrato);
					for(int j=0; j<periodos.size(); j++)			
						periodos.get(j).getFlats().get(i).setIdCategoria(categoria.getIdCategoria());
				}
				else
					feesContratoDAO.actualizarCategoria(categoria);											
			}	
		}	
	}

	public void eliminarCategorias(Long idContrato){
		  feesContratoDAO.eliminarCategoriasContrato(idContrato);
	}
	
	public List<CategoriaFeesDTO> getCategoriasTitulosXContrato (Long idContrato){
		return feesContratoDAO.getCategoriasTitulosXContrato(idContrato);
	}
		
	public List<CategoriaFeesDTO> getCategoriasTitulosXCategoria(Long idCategoria){
		return feesContratoDAO.getCategoriasTitulosXCategoria(idCategoria);
	}
	
	public List<FeesContratoPagoDTO> eliminarCategoriaFlat(Long idCategoria, List<FeesContratoPagoDTO> periodos){
		   feesContratoDAO.eliminarPagoFlatByCategoria(idCategoria);							
		   
		   for(FeesContratoPagoDTO periodo: periodos)
		   {
				  //se elimina la categoria insertada para el minimo de seleccion
				  minimoSeleccionBO.eliminarMinSeleccion(periodo.getIdContratoPago(), idCategoria);
				  int index = -1;
				  for(int i=0; i<periodo.getFlats().size(); i++)			  
					 if(periodo.getFlats().get(i).getIdCategoria().longValue() == idCategoria.longValue())
						 index = i;
				  
				  if(index != -1)
				     periodo.getFlats().remove(index);
		   }		  			   		     		   
		   feesContratoDAO.actualizarTitulosTCateg(idCategoria);   //Se elimina la relacion de la categoria con los titulos
		   feesContratoDAO.actualizarTitulosMCateg(idCategoria);		   		   
		   feesContratoDAO.eliminarPagoCategoria(idCategoria);	   //Se elimino la categoria
		   return periodos;
	}

	public String actualizarCostoTitulos(Map<String, Object> paramNumeroContrato) {
		
		return feesContratoDAO.actualizarCostoTitulos(paramNumeroContrato);
	}
}
