package com.mx.dla.dda.contrato.transaccion.minimoGarantizado.bos;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.minimoGarantizado.daos.MinimoGarantizadoDAO;
import com.mx.dla.dda.contrato.transaccion.minimoGarantizado.dtos.MinGarantizadoDTO;

import com.mx.dla.global.bos.BaseBO;

@Component
public class MinimoGarantizadoBO extends BaseBO {

	@Autowired
	private MinimoGarantizadoDAO minimoGarantizadoDAO;

	@Autowired
	private GeneralesDAO generalesDAO;

	Long IdContratoOrig;

	public List<MinGarantizadoDTO> consultaInformacionMinimos(Long idContrato) throws ResultMapException, SQLException, TransaccionException {
		try {
			ContratoDTO contrato = generalesDAO.obtenerContrato(idContrato);
			IdContratoOrig = contrato.getIdContratoOriginal();

			return minimoGarantizadoDAO.consultaMinimoGarantizado(IdContratoOrig);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}
	}

}
