package com.mx.dla.admin.dtos;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class MenuDTO implements Serializable {

	private static final long serialVersionUID = 1L;

	private String idMenu = "";
	private String nombre = "";
	private String descripcion = "";
	private String orden = "";
	private String tipoMenu = "";
	private String estatus = "";
	private String script = "";
	private String parametros = "";
	private String iconClass = "";
	private String idMenuPadre = "";
	private String enMtto = "";

	// --*** Atributos solo de lectura, no estan en la BD
	private String ruta = "";
	private String nivel = "";

	private List<MenuDTO> hijos = null;

	public MenuDTO obtenerMenu(String idMenu) {

		if (idMenu == null)
			return null;

		if (this.hijos != null) {

			for (MenuDTO menu : this.hijos) {

				if (menu != null && menu.getIdMenu().equals(idMenu)) {
					return menu;
				} else {
					MenuDTO menuHijo = menu.obtenerMenu(idMenu);
					if (menuHijo != null)
						return menuHijo;
				}
			}
		}

		return null;
	}

	public String toString() {
		return this.idMenu + ',' + this.nombre + ',' + this.descripcion + ',' + this.orden + ',' + this.tipoMenu + ','
				+ this.estatus + ',' + this.script + ',' + this.parametros + ',' + this.idMenuPadre + ',' + this.enMtto;
	}
}
