var idEstudio;

$(document).ready(
	function() {
		inicial();
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
    // Obtener número de menú
    var menu = $("#pmn").val();
    var menuRegreso = $("#pmnReturn").val();
    var namespace = "/catalogos/estudiosTrans/";
    var rowId = null;
    var oTable = null;
    
    oTable = $('#cataEstudio').DataTable({		    
        autoWidth: false,
        language: {	
            processing: "Procesando...",
            lengthMenu: "Mostrar _MENU_ registros",
            zeroRecords: "Sin eventos encontrados",
            emptyTable: "Sin eventos encontrados",
            info: "Mostrando _START_ al _END_ de _TOTAL_",
            infoEmpty: "0 registros",
            infoFiltered: "(filtrado de un total de _MAX_ registros)",
            search: "Buscar:",
            thousands: ",",
            loadingRecords: "Cargando...",
            paginate: {
                first: "Primero",
                last: "&Uacute;ltimo",
                next: "Siguiente",
                previous: "Anterior"
            }
        },
        pageLength: 10,
        info: false,
        filter: true,
        ordering: false,
        paging: true,
        pagingType: "full_numbers",
        order: [],
        ajax: {
            url: "listadoEstudiosTrans",
            dataSrc: ""
        },
        columns: [
            { title: "Nombre", data: "nombre", searchable: true, width: "100px" },
            { title: "Revenue Share", data: "revenueShare", searchable: true, width: "50px" },
            { title: "Accion", data: "nombre", searchable: true, width: "30px" }
        ],
        rowCallback: function(row, data, index) {
            var link = '<a onClick="actualizaEstudio(' + data["idEstudio"] + ')" data-bs-toggle="modal" data-bs-target="#modalAgregaActualiza">' + data["nombre"] + '</a>';
            var button = '<button class="btn btn-danger" type="button" onclick="eliminar(' + data["idEstudio"] + ')">Eliminar</button>';
            $(row).attr("id", data["idEstudio"]);
            $('td:eq(0)', row).html(link);
            $('td:eq(1)', row).html(data["revenueShare"]);
            $('td:eq(2)', row).html(button);
        }
    });
}


function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanum\u00E9ricos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function eliminar(id){
	if(confirm('¿Esta seguro de borrar este registro?')){
		var jsonString = '{"idEstudio" : "' + id + '"}';
		var stringJson = JSON.parse(jsonString);
		callActionAjax("/catalogos/estudiosTrans/eliminaEstudioTrans", stringJson, procesaRespuestaActualiza);
	}
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{		
		window.location.href = contextPath + "/catalogos/estudiosTrans/dirigirAgregarEstudioTrans.action?pmn=211&pmnReturn=211";				
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 211;
	window.location.href = contextPath + "/catalogos/estudiosTrans/index.action?pmn=" + menu;
}

function actualizaEstudio(idEstud) {	
	idEstudio = idEstud;
	llamaObtenEstudio(idEstudio);
}

function llamaObtenEstudio(idEstudio) {
	var jsonString = '{"idEstudio" : "'+ idEstudio +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/estudiosTrans/llamaObtenEstudio", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	var est = jsonData.estudio;
	var reps = jsonData.reportes;
	var rep;
	//debugger
	$('#inpNombreEstudio').val(est.nombre);
	$('#inpRevenueShare').val(est.revenueShare);
}

function llamaActualizaEstudio() {
	var nombre = $('#inpNombreEstudio').val();
	var revenue = $('#inpRevenueShare').val();
	var jsonString = '{"idEstudio" : "'+ idEstudio + '", "nombreEstudio" : "' + nombre + '", "revenueShare" : "' + revenue + '"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/estudiosTrans/llamaActualizaEstudio", stringJson, procesaRespuestaActualiza);

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.seRepiteSigla;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(!seRepite) {
		showMessage("Actualizado con exito");
	}else {
		showError("La sigla se repite en otro Estudio.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}