
var montosIniciales = [];

$(document).ready(function() {		
		//debugger
		cargaInicialCondicional();						   	
		inicializarInputs();
		$("#formaId").validate();
		$("#errLabNumFac").hide();
								
		$('#botonGuardar').click(function() {						
			    $('#estudioEleccion').attr('disabled', false);			    	
			    var contratos = [];
			    var aPagarRows = 0;
			    var formaValida     = true;
			    
			    $("#tFacturaDetalle2 tr[id^=idM]").each(function(){
			    	
			    	if($(this).find("input:last").val() != "")
			    	{ 			    					    	
				    	var contrato  = new Contrato();
				    	var mes       = new Mes();
					    var meses     = [];			    
					    			    
						mes.mes   = $(this).find("input:last").attr("mes"); 
						mes.pagar = unformatCurrency($(this).find("input:last").val());
						mes.nuevo = $(this).find("input:last").attr("nuevo");				    				    
						meses.push(mes);
						
						console.log($("#approved").val());
						if(mes.pagar && mes.pagar > 0.0)aPagarRows++;
						
						contrato.idContratoOri = $(this).find("input:last").attr("idOri");
			    		contrato.meses         = meses;
			    		contratos.push(contrato);
			    		
			    		if($(this).find("input:last").attr("valido") == "false")
			    		{
			    			if(formaValida)
			    			   formaValida = false;	
			    		}
			    	}
			    	
				});

			    $("#detalleCto").val(JSON.stringify(contratos))
			    
			    if(contratos.length == 0)
			    {
			    	showError("No se han registrado valores.");
			        formaValida = false;
			    }else
			    	if(aPagarRows > 1){
				    	showError("Solo se permite tener una cantidad a pagar de un mes y un contrato.");
				        formaValida = false;
			    	}
			    else 
			    	if(!validaMontoTotal()){
				    	showError("El valor del monto total es inv\u00E1lido, checar los valores capturados.");
				        formaValida = false;
			    	}
			    else
			    	if(!validaInputs())
				        formaValida = false;
			    
			    if(formaValida)
			    {
			    	generarDatosRest();
			    	$("#formaId").submit();			    				
			    }						       								
	    });							
});

function generarDatosRest(){
	var pagado    = 0;
	var contratos = [];
	
	$("#tFacturaDetalle2 tr[id^=idC]").each(function(){    	
		var contrato = new Contrato();		 			
		var idCto    = parseInt($(this).attr("id").substring(4,$(this).attr("id").length));
		contrato.contratoDesc = $(this).find("td:nth-child(1)").find("ins").html();		
		contrato.total        = parseFloat(unformatCurrency($(this).find("td:nth-child(3)").text()));
		contrato.idSapCto     = $(this).attr("sap");
		contrato.pendiente    = parseFloat(unformatCurrency($(this).find("td:nth-child(5)").text()));
		pagado = pagado + contrato.total;
		contratos.push(contrato);						    	    	
	});
		debugger	
	var aprovada = $("#approved").is(':checked') ? 1 : 0;
	var fecha    = $("#fechaFactura").val().split("/");
	var factura = { numeroFactura: $("#numeroFactura").val(), 
			        monto        : $("#monto").val(), 
			        contratos    : contratos, 				
			        approved     : aprovada,
			        idEstudio    : $("#estudioEleccion").val(), 
			        fechaFactura : fecha[2]+"-"+fecha[0]+"-"+fecha[1],
			        indicadorIva : $("#indicadorIva").val(),
			        idFactura    : $('#facturaIdentificador').val(),
			        tipoPago     : $('#tipoPago').val()
	              }
	if(aprovada == 1)
	   $("#restCto").val(JSON.stringify(factura));				   	
}

function inicializarInputs(){
	$("#approved").click(function () {
		var valor = $("#approved").val();
		if ( valor === "1")
			confirm("Aviso", "Aprobar la factura evitara cualquier futura edicion.");
	});

	var valora = $("#approvedRadioButtonValor").val();
	if(valora === "0" || valora === "")
	{
		 $('#sapRadioButton').empty();
	}	
}

function cargaInicialCondicional(){	
	var idFactura = $('#facturaIdentificador').val();
	var aprobada  = $("input[name='factura.approved']:checked").val();
		
	if ( validaNuloUndefinido(idFactura) === 0)
	{				 		 
		 $('#botonConsultarFactura').append(crearBotonConsultaDetalle());
		 		 
		 $("input[type=radio][value=0]").attr('checked', true);
		 		 
		 $('#estudioEleccion').change(function() {
			    $('#facturaDetalleContainer').remove();
		 });		 		 
		 
		 $('#divInputFactura').hide();
		 $('#divComentario').hide();		 
		 $('#divRadio')     .hide();
		 $('#botonGuardar') .hide();		 
	}
	else
	{	
		 getDataAction();
		 $('#estudioEleccion').attr("disabled", true);
		 $('#indicadorIva').attr("disabled", true);
		 
		 $.post( contextPath + '/factura/general/facturaGeneral',{} )
		 .done(function( response ) 
		  {    		     		     				
			 if(response.factura.approved == 0)
			 {
				 $('#numeroFactura')   .prop('readonly', false);				
				 $('#fechaFactura')    .prop('disabled', false);
				 $("input[type=radio]").attr('disabled', false);
				 $('#comentario')      .attr('readonly', false);
				 $('#tipoPago').attr("disabled", false);
				 
				 $('#botonGuardar').show();				 
				 $('#sapRadioButton').hide();
				 
				 if($("input[name='factura.approved']:checked").val() == 1)
					 showMessage("La factura no se ha notificado a SAP.")
			 }
			 else
			 {
					$('#numeroFactura')   .prop('readonly', true);				
					$('#fechaFactura')    .prop('disabled', true);
					$("input[type=radio]").attr('disabled', true);
					$('#comentario')      .attr('readonly', true);
					$('#tipoPago').attr("disabled", true);

					$('#botonGuardar').hide();
					
					if(validaNuloUndefinido(response.factura.fechaSapI17) != 0 && validaNuloUndefinido(response.factura.fechaSapI32) != 0
								&& validaNuloUndefinido(response.factura.fechaSapI14) != 0)
					     $('#botonReenvioServicio').hide();
					else	
						 $('#botonReenvioServicio').append(crearBotonReenvioNotificacionFactura());
			 }
		 });				 		
	}
}    

function crearBotonConsultaDetalle(){
	var botonAgregar = $("<button/>").attr("id", "botonConsultarFacturaDetalle").attr("type", "button")
	                    .addClass("btn btn-info").text("Consultar contratos");
	
	botonAgregar.click(function() {
   	 				
		   var estudioEleccion = $('#estudioEleccion').val();
		   var indicador       = $('#indicadorIva').val();
   	 
		   if (validaNuloUndefinido(estudioEleccion) != 0 && validaNuloUndefinido(indicador) != 0)
		   {
			   $("#tFacturaDetalle2").remove();
			   getDataAction();
			   $('#divInputFactura').show();
			   $('#divComentario').show();
			   $('#divRadio')     .show();
			   $('#botonGuardar') .show();
		   }			   
   	       else 
   		       showError("Seleccione un valor de Estudio e indicador de IVA valido");   		      		

    });	
    return botonAgregar;
}

function getDataAction(){		
		 var eleccionEstudio      = $('#estudioEleccion').val();
		 var indicador            = $('#indicadorIva').val();
		 var identificadorFactura = $('#facturaIdentificador').val();
		 var facturaAprobada      = $("input[name='factura.approved']:checked").val();
		 
		  if (validaNuloUndefinido(eleccionEstudio) == 0)
			  eleccionEstudio = null;
		  		 
		  if (validaNuloUndefinido(identificadorFactura) == 0)
			  identificadorFactura = null;
		  		  
		  if (validaNuloUndefinido(facturaAprobada) == 0)
			  facturaAprobada = 0;		  

		 $.ajax({
		     url: contextPath + "/factura/general/facturacionDetalleCarga",
		     type: 'POST',
		     data:  { "idEstudio" : eleccionEstudio, "idFactura" : identificadorFactura, "aprobado" : facturaAprobada, "indicadorIVA" : indicador }, 
			 dataType: "json",
		     success:function(response){ 
		    	 
		    	 if(response.indicadorIVA != null || response.indicadorIVA != "")
		    	    $('#indicadorIva').val(response.indicadorIVA);		    	 
		    	 generaTabla(response, facturaAprobada);        
		     },
		     error:function(jqXhr, textStatus, errorThrown){
		         alert("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
		     }
		 });
}

function validaNuloUndefinido(variable){	
	if( (variable === null && typeof variable === "object") ||
	    (variable === undefined && typeof variable === "undefined") ||
	    (variable === "" && typeof variable === "string")
	  )
	    return 0;
	else  return variable;	
}

function formatCurrency(unformatedCurrency, n, x) {
	var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
	return unformatedCurrency.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,');
};

function unformatCurrency(formatedCurrency) {
	return String(formatedCurrency).replace(/ /g, "").replace(/,/g, "").replace("$", "");
};

function validateCurrency(currencyString, decimales) {
	var currency_regex = /(?=.)^\$?(([1-9][0-9]{0,2}(,[0-9]{3})*)|[0-9]+)?(\.[0-9]{1,4})?$/;
	return currency_regex.test(currencyString);
}

function validaFechaValida(dateString){
	/*  MM/DD/YYYY  */
	var date_regex = /^((?:(?:(?:(?:0?[13578])|(1[02]))\/31\/(19|20)?\d\d)|(?:(?:(?:0?[13-9])|(?:1[0-2]))\/(?:29|30)\/(?:19|20)?\d\d)|(?:0?2\/29\/(?:19|20)(?:(?:[02468][048])|(?:[13579][26])))|(?:(?:(?:0?[1-9])|(?:1[0-2]))\/(?:(?:0?[1-9])|(?:1\d)|(?:2[0-8]))\/(?:19|20)?\d\d)))$/;
	return date_regex.test(dateString);
}



function valida(){
  if($("#numeroFactura").val().length>12)
  {
	  return false;
  }
  else return true;  
}

function validaInputs(){
	
	  var valido = false;

	  if(esStringVacio($("#numeroFactura").val()))
			showError("No se ha capturado un Numero de Factura v\u00E1lido");
	  else if($("#numeroFactura").val().length>12)
	    	showError("El tamanio del Numero de Factura capturado es mayor a 12 caracteres.");
	  else if(esStringVacio($("#fechaFactura").val()))
			showError("No se ha capturado una Fecha de Factura v\u00E1lida");
	  else if (!validaFechaValida($("#fechaFactura").val()))
			showError("El formato de la Fecha de Factura es inv\u00E1lida");
	  else if(esStringVacio($("#tipoPago").val()))
			showError("No se ha elegido un Tipo de Pago v\u00E1lido");
	  else valido = true;

	  return valido;  
}

function confirm(heading, question) {
    var confirmModal = 
        $('<div class="modal fade" id="myModal" role="dialog">'+
      '<div class="modal-dialog modal-sm">'+
        '<div class="modal-content">'+
          '<div class="modal-header">'+
            '<button type="button" class="close" data-dismiss="modal">&times;</button>'+
            '<h4 class="modal-title">' + heading +'</h4>'+
          '</div>'+
          '<div class="modal-body">'+
            '<p>' + question + '</p>'+
          '</div>'+
          '<div class="modal-footer">'+
            '<button type="button" class="btn btn-default" data-dismiss="modal">Ok</button>'+
          '</div>'+
        '</div>'+
      '</div>'+
    '</div>'); 
    confirmModal.modal('show'); 
};  

function validaMontoTotal(){
	if($("#monto").val() == "" || parseFloat(unformatCurrency($("#monto").val())) == 0)
		return false
	else
		return true;
};

function esStringVacio (valor){
	return valor ? valor.trim().length == 0 : true; 
};

function actualizaForma(){
	$("#tFacturaDetalle2").remove();
	$("#botonGuardar").hide();
	$("#monto").val("");	
};


function reenvioNotificacionFactura(idFactura){	
	
	if(idFactura){

	 $.ajax({
	     url: contextPath + "/factura/general/facturacionReenvioNotificacion",
	     type: 'POST',
	     data:  { "idFactura" : idFactura}, 
		 dataType: "json",
	     success:function(response){ 
	    	 
				console.log(response.factura.approved);
				console.log(response.factura.fechaSapI17);
				console.log(response.factura.fechaSapI32);
				console.log(response.factura.fechaSapI14);
				
				if(validaNuloUndefinido(response.factura.fechaSapI17) != 0 && validaNuloUndefinido(response.factura.fechaSapI32) != 0
						&& validaNuloUndefinido(response.factura.fechaSapI14) != 0)
					 $('#botonReenvioServicio').hide();
				
				
			showMessage("La notificacion de la factura ha sido reenviada a SAP.")
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         alert("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	     }
	 });
	 
	}
	
};

function consultaFactura(idFactura){	
	
	if(idFactura){

	 $.ajax({
	     url: contextPath + "/factura/general/facturacionConsultaFactura",
	     type: 'POST',
	     data:  { "idFactura" : idFactura }, 
		 dataType: "json",
	     success:function(response){ 
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	     }
	 });
	 
	}
	
};

function crearBotonReenvioNotificacionFactura(){
	
	var botonAgregar = $("<button/>").attr("id", "botonReenvioNotificacionFactura").attr("type", "button")
	                    .addClass("btn btn-info").text("Reenviar a SAP");
	
	botonAgregar.click(function() {
		 var identificadorFactura = $('#facturaIdentificador').val();
		 reenvioNotificacionFactura(identificadorFactura);  		      		
    });	
	
    return botonAgregar;
}