function generaTablaDetalle(notaCreditoData, aprobada) {

	var detalleTamanio = 0;

	if (notaCreditoData.notaCredito !== null
			&& notaCreditoData.notaCredito.contratos !== null) {
		detalleTamanio = notaCreditoData.notaCredito.contratos.length;
		if (detalleTamanio > 0)
			$('#botonGuardar').attr('disabled', false);
		renderTablaDetalleNotaCredito(notaCreditoData.notaCredito.contratos);
		
		desactivaInputsAprobada($("input[name='notaCredito.approved']:checked").val());

		sumatoriaPorNota();
	}
}

function renderTablaDetalleNotaCredito(contratos) {
	var tabla = $("<table/>").attr("id", "tFacturaDetalle").addClass(
			"table factura");
	var encabezado = crearEncabezado();
	var cuerpo = $("<tbody/>");

	for (var i = 0; i < contratos.length; i++) {
		cuerpo.append(crearFilaContrato(contratos[i]));

		for (var j = 0; j < contratos[i].titulos.length; j++) 
			cuerpo.append(crearFilaMes(contratos[i], contratos[i].titulos[j]));
	}

	tabla.append(encabezado).append(cuerpo);
	$("#tablaFacturaDetalle").append(tabla);
	$("#tFacturaDetalle tr.accordion-body").collapse('toggle');
}

function crearEncabezado() {
	var fila = $("<tr/>").addClass("encabezado").append(
			$("<th/>").text("Contrato")).append($("<th/>").text("Origen")).append($("<th/>").text("Titulo")).append(
			$("<th/>").text("Costo")).append($("<th/>").text("Monto"));
	return $("<thead/>").append(fila);
}

function crearFilaContrato(contrato) {

	var idContrato = contrato.idContrato;
	var descripcionContrato = contrato.numeroContrato;
	var costoTotalContrato = contrato.costo;
	var montoTotalContrato = contrato.monto;
	var idSapContrato = contrato.idSap;
	var claveIvaContrato = contrato.claveIva;

	var fila = $("<tr/>")
			.attr("id", "idC-" + idContrato)
			.attr("data-bs-toggle", "collapse")
			.attr("data-bs-target", ".packageDetails" + idContrato)
			.attr("idSap", idSapContrato)
			.attr("claveIva", claveIvaContrato)
			.addClass("trContrato accordion-toggle")
			.append($("<td/>").append("<ins>" + descripcionContrato + "</ins>"))
			.append($("<td/>"))
			.append($("<td/>"))
			.append(
					$("<td/>")
							.text(
									formatCurrency(
											Number(unformatCurrency(costoTotalContrato)),
											4)))
			.append(
					$("<td/>")
							.text(
									formatCurrency(
											Number(unformatCurrency(montoTotalContrato)),
											4)));
	return fila;
}

function crearFilaMes(contrato, titulo) {

	var idContrato = contrato.idContrato;
	var idContratoOrigen = contrato.idContrato;
	var idTitulo = titulo.idTituloCnt;
	var descripcionTitulo = titulo.descTitulo;
	var tipoTitulo = titulo.tipoTitulo;
	var esNuevo = titulo.nuevo;
	var costo = titulo.costo;
	var monto = titulo.monto;
	var descTipoTitulo = '';

	var input = $("<input type='text'/>").attr("idCto", idContrato).attr("mes",
			descripcionTitulo).attr("idOri", idContratoOrigen).attr("nuevo",
			esNuevo).attr("readonly", false).attr("idTto", idTitulo).attr("valido", true).val(
			formatCurrency(Number(unformatCurrency(monto)), 4)).change(
			function() {

				if ($(this).val() != "") {
					var resultado = validaMonto($(this).val());

					if (!resultado.valido) {
						showError(resultado.mensaje);
						$(this).attr("valido", false);
					} else {

						$(this).attr("valido", true);
						$(this).val(
								formatCurrency(Number(unformatCurrency($(this)
										.val())), 4));
						sumatoriaPorContrato(idContrato);
						$(this).attr("guardar", true);

					}
					formaValida = true;
				}

			});
	
	if (tipoTitulo == 0) 
		descTipoTitulo = 'BAJA';
	else descTipoTitulo = 'DISMINUCION';

	var fila = $("<tr/>")
			.attr("id", "idM" + "-" + idContrato + "-" + descripcionTitulo)
			.addClass(
					"trMes accordion-body packageDetails" + idContrato
							+ " collapse in")
			.append($("<td/>"))
			.append($("<td/>").append( descTipoTitulo ))
			.append($("<td/>").append("<ins>" + descripcionTitulo + "</ins>"))
			.append(
					$("<td/>").text(
							formatCurrency(Number(unformatCurrency(costo)), 4)))
			.append($("<td/>").append(input));
	return fila;
}

function sumatoriaPorContrato(idContrato){
	var totalContrato = 0.0;
	
	$("#tFacturaDetalle tr[id^=idM-"+ idContrato +"]").each(function(){ 
		var montoInput = $(this).find("input:last");
		totalContrato = totalContrato + Number(unformatCurrency(montoInput.val()));
	});
	
	$("#tFacturaDetalle tr[id^=idC-"+idContrato+"]").find("td:last-child").text(formatCurrency(Number(unformatCurrency(totalContrato)), 4));    		    	    		

	sumatoriaPorNota();
}

function sumatoriaPorNota(){
	var totalContrato = 0.0;
	
	$("#tFacturaDetalle tr[id^=idC]").each(function(){ 
		var montoInput = $(this).find("td:last-child");
		totalContrato = totalContrato + Number(unformatCurrency(montoInput.text()));
	});
	
	$("#montoNotaCredito").val(formatCurrency(Number(unformatCurrency(totalContrato)), 4));    		    	    		
}

function validaMonto(valor) {
	var resultado = {
		valido : true,
		mensaje : ""
	};
	valor = unformatCurrency(valor);

	if (!validateCurrency(valor)) {
		resultado.valido = false;
		resultado.mensaje = "El valor ingresado no es un n\u00FAmero.";
	} else if (parseFloat(valor) < 0) {
		resultado.valido = false;
		resultado.mensaje = "El valor ingresado debe ser mayor o igual a 0.";
	}
	return resultado;
}