package com.mx.dla.dda.admin.catalogos.grupoestudio.bos;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.grupoestudio.daos.GrupoEstudioDAO;
import com.mx.dla.dda.admin.catalogos.grupoestudio.dtos.GrupoEstudioDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class GrupoEstudioBO extends BaseBO {

	@Autowired
	private GrupoEstudioDAO grupoEstudioDAO;

	public List<GrupoEstudioDTO> obtenerGrupoEstudio(Long idEstudio)
			throws ResultMapException, SQLException, TransaccionException {

		List<GrupoEstudioDTO> grupos = null;

		try {
			grupos = grupoEstudioDAO.obtenerGrupoEstudio();

			GrupoEstudioDTO grupo = null;
			if (idEstudio != null)
				grupo = grupoEstudioDAO.obtenerGrupoEstudioInactivoByEstudio(idEstudio);

			if (grupo != null)
				grupos.add(grupo);

			Collections.sort(grupos, new Comparator<GrupoEstudioDTO>() {
				@Override
				public int compare(GrupoEstudioDTO o1, GrupoEstudioDTO o2) {
					return o1.getDescripcionGrupo().compareTo(o2.getDescripcionGrupo());
				}
			});

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

		return grupos;
	}

	public GrupoEstudioDTO obtenerGrupo(Long idGrupo) throws ResultMapException, SQLException, TransaccionException {
		GrupoEstudioDTO grupo = null;

		try {
			grupo = grupoEstudioDAO.obtenerGrupo(idGrupo);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

		return grupo;
	}

	public void registraActualizaGrupo(String operacion, Long idGrupo, String descripcion, Integer estatus,
			Integer orden, Integer colapsa) throws ResultMapException, SQLException, TransaccionException {

		GrupoEstudioDTO grupo = new GrupoEstudioDTO();

		grupo.setIdGrupo(idGrupo);
		grupo.setDescripcionGrupo(descripcion);
		grupo.setEstatus(estatus);
		grupo.setOrden(orden);
		grupo.setColapsa(colapsa);

		try {

			if (operacion.equals("Actualiza")) {
				grupoEstudioDAO.actualizaGrupoEstudio(grupo);
			} else {
				grupoEstudioDAO.registrarGrupoEstudio(grupo);
			}

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

}
