package com.mx.dla.admin.dtos;

import java.io.Serializable;
import java.util.List;

public class MenuDTO implements Serializable {

	private static final long serialVersionUID = 1L;

	private String idMenu = "";
	private String nombre = "";
	private String descripcion = "";
	private String orden = "";
	private String tipoMenu = "";
	private String estatus = "";
	private String script = "";
	private String parametros = "";
	private String iconClass = "";
	private String idMenuPadre = "";
	private String enMtto = "";

	// --*** Atributos solo de lectura, no estan en la BD
	private String ruta = "";
	private String nivel = "";

	private List<MenuDTO> hijos = null;

	public String getIdMenu() {
		return this.idMenu;
	}

	public void setIdMenu(String valor) {
		this.idMenu = valor;
	}

	public String getNombre() {
		return this.nombre;
	}

	public void setNombre(String valor) {
		this.nombre = valor;
	}

	public String getDescripcion() {
		return this.descripcion;
	}

	public void setDescripcion(String valor) {
		this.descripcion = valor;
	}

	public String getOrden() {
		return this.orden;
	}

	public void setOrden(String valor) {
		this.orden = valor;
	}

	public String getTipoMenu() {
		return this.tipoMenu;
	}

	public void setTipoMenu(String valor) {
		this.tipoMenu = valor;
	}

	public String getEstatus() {
		return this.estatus;
	}

	public void setEstatus(String valor) {
		this.estatus = valor;
	}

	public String getScript() {
		return this.script;
	}

	public void setScript(String valor) {
		this.script = valor;
	}

	public String getParametros() {
		return this.parametros;
	}

	public void setParametros(String valor) {
		this.parametros = valor;
	}

	public String getIconClass() {
		return iconClass;
	}

	public void setIconClass(String iconClass) {
		this.iconClass = iconClass;
	}

	public String getIdMenuPadre() {
		return this.idMenuPadre;
	}

	public void setIdMenuPadre(String valor) {
		this.idMenuPadre = valor;
	}

	public String getEnMtto() {
		return this.enMtto;
	}

	public void setEnMtto(String valor) {
		this.enMtto = valor;
	}

	public String getRuta() {
		return ruta;
	}

	public void setRuta(String ruta) {
		this.ruta = ruta;
	}

	public String getNivel() {
		return nivel;
	}

	public void setNivel(String nivel) {
		this.nivel = nivel;
	}

	public List<MenuDTO> getHijos() {
		return hijos;
	}

	public void setHijos(List<MenuDTO> hijos) {
		this.hijos = hijos;
	}

	public MenuDTO obtenerMenu(String idMenu) {

		if (idMenu == null)
			return null;

		if (this.hijos != null) {

			for (MenuDTO menu : this.hijos) {

				if (menu != null && menu.getIdMenu().equals(idMenu)) {
					return menu;
				} else {
					MenuDTO menuHijo = menu.obtenerMenu(idMenu);
					if (menuHijo != null)
						return menuHijo;
				}
			}
		}

		return null;
	}

	public String toString() {
		return this.idMenu + ',' + this.nombre + ',' + this.descripcion + ',' + this.orden + ',' + this.tipoMenu + ','
				+ this.estatus + ',' + this.script + ',' + this.parametros + ',' + this.idMenuPadre + ',' + this.enMtto;
	}
}
