package com.mx.dla.dda.general.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;

public enum MesesAnio implements Catalogable {

	Enero("1", "Enero", "Ene"), Febrero("2", "Febrero", "Feb"), Marzo("3", "Marzo", "Mar"), Abril(
			"4", "Abril", "Abr"), Mayo("5", "Mayo", "May"), Junio("6", "Junio", "Jun"), Julio("7",
			"Julio", "Jul"), Agosto("8", "Agosto", "Ago"), Septiembre("9", "Septiembre", "Sep"), Octubre(
			"10", "Octubre", "Oct"), Noviembre("11", "Noviembre", "Nov"), Diciembre("12",
			"Diciembre", "Dic");

	private String id;
	private String desc;
	private String shortDesc;

	MesesAnio(String type, String desc, String shortDesc) {
		this.id = type;
		this.desc = desc;
		this.shortDesc = shortDesc;
	}

	public String getDesc() {
		return desc;
	}
	
	public String getShortDesc() {
		return shortDesc;
	}

	public void setShortDesc(String shortDesc) {
		this.shortDesc = shortDesc;
	}

	public String getType() {
		return id;
	}

	@Override
	public String getValue() {
		return id;
	}

	public static MesesAnio parse(String tipo) {
		MesesAnio[] values = MesesAnio.values();
		MesesAnio target = null;
		for (MesesAnio t : values) {
			if (t.getType().equals(tipo)) {
				target = t;
				break;
			}
		}
		return target;

	}

}
