package com.mx.dla.admin.actions;


import java.util.HashMap;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.global.actions.BaseAction;

@Controller
@Scope("request")
public class ErrorAction extends BaseAction {
	
	private static final long serialVersionUID = 1L;
	
	private String clave = "";
    private String descripcion = "";
    private String url = "";

    private HashMap< String, String > urlHM;
    
    private ErrorAction() throws Exception {
    	super();
    	
    	urlHM = new HashMap< String, String >();
    	
    	urlHM.put("002", "/j_spring_security_logout");
    }
    
    @Override
	public String execute() throws Exception {
		
    	this.descripcion = "error_" + this.clave;
    	this.url = urlHM.get( this.clave );
    	
    	if( this.clave.equals("001") || this.clave.equals("002") )
    		return "error";
    	
    	return SUCCESS;
	}
    
    public String getClave(){
        return this.clave;
    }

    public void setClave( String valor ){
        this.clave = valor;
    }

    public String getDescripcion(){
        return this.descripcion;
    }

    public void setDescripcion( String valor ){
        this.descripcion = valor;
    }

    public String getUrl(){
        return this.url;
    }

    public void setUrl( String valor ){
        this.url = valor;
    }
	
}