package com.mx.dla.admin.usuarios.perfil.actions;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.admin.usuarios.perfil.bos.UsuarioPerfilBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;

public class UsuarioPerfilAction extends BaseContratoAction{
	
	private static final long serialVersionUID = 1L;
	
	public UsuarioDTO usuario;
	public String correoElectronico;
	public String contrasena;
	public String operacion;
	public boolean exito;
	
	@Autowired
	private UsuarioPerfilBO usuarioPerfilBO;
	
	@Override
	public String execute() {
		setUsuario((UsuarioDTO) this.getSession().get("usuario"));
		//logger.debug("keys : [{}]", this.getSession().keySet());
		//logger.debug("menus : [{}]", this.getSession().get("menus"));
		//logger.debug("idContrato : [{}]", this.getSession().get("idContrato"));
		this.getSession().put("pmn", null);
		this.getSession().put("pmnReturn", null);
		//logger.debug("usuario : [{}]", usuario);
		//logger.debug("pmn : [{}] --- pmnReturn : [{}]", this.getPmn(), this.getPmnReturn());
		return SUCCESS;
	}
	
	public String actulizaPropiedadesUsuario(){
		setUsuario((UsuarioDTO) this.getSession().get("usuario"));
		setExito(usuarioPerfilBO.actulizaPropiedadUsuario(usuario.getExpediente(), correoElectronico, contrasena, operacion));
		setUsuario(usuarioPerfilBO.obtenerUsuario(usuario.getExpediente()));
		this.getSession().put("usuario", usuario);
		return SUCCESS;
	}
	
	public void setUsuario(UsuarioDTO usuario) {
		this.usuario = usuario;
	}
	
	public UsuarioDTO getUsuario() {
		return usuario;
	}
	
	public void setCorreoElectronico(String correoElectronico) {
		this.correoElectronico = correoElectronico;
	}
	
	public String getCorreoElectronico() {
		return correoElectronico;
	}
	
	public void setContrasena(String contrasena) {
		this.contrasena = contrasena;
	}
	
	public String getContrasena() {
		return contrasena;
	}
	
	public void setOperacion(String operacion) {
		this.operacion = operacion;
	}
	
	public String getOperacion() {
		return operacion;
	}
	
	public void setExito(boolean exito) {
		this.exito = exito;
	}
	
	public boolean getExito() {
		return exito;
	}
}
