package com.mx.dla.dda.admin.bloqueo.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.carga.transaccion.dtos.FechaBloqueoDTO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;
public class BloqueoSAPAction extends BaseAction {

	private static final long serialVersionUID = -1L;
	private static Logger log = Logger.getLogger(BloqueoSAPAction.class);
	
	private boolean regresoAction;
	
	private String anio;
	private String mes;
	private String dia;
	
	
	@Autowired
	private CargaTransaccionesBO bdsp;
	
	private String fecha;
	
	@Override
	public String execute() throws Exception {
		LocalDate currentDate = LocalDate.now();
		FechaBloqueoDTO fecha = bdsp.consultaMesActual(String.valueOf(currentDate.getYear()), 
				String.valueOf(currentDate.getMonthValue()));
		setAnio(fecha.getAnio());
		setMes(fecha.getMes());
		setDia(fecha.getDia());
		return SUCCESS;
	}
	
		

	

	public String ejecutaBloqueoSAP() {

		try {
			bdsp.ejecutaSP(fecha);
			
			
		} catch (Exception e) {
			addActionError("Ha ocurrido el siguiente error durante la consulta: "
					+ e.getMessage());
		}

		return Action.SUCCESS;
	}


	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public String getAnio() {
		return anio;
	}

	public void setAnio(String anio) {
		this.anio = anio;
	}

	public String getMes() {
		return mes;
	}

	public void setMes(String mes) {
		this.mes = mes;
	}
	
	public String getDia() {
		return dia;
	}

	public void setDia(String dia) {
		this.dia = dia;
	}	
}
