package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.CategoriasDTO;
import com.mx.dla.global.actions.BaseAction;

import lombok.Data;

@Data
public class CategoriasAction extends BaseAction {
	
	private List<CategoriasDTO> categorias;
	private CategoriasDTO categoria;
	private String nombreCategoria;
	private String idCategoria;
	
	@Autowired
	private TransaccionesBO transacciones;
	
	@Override
	public String execute() throws Exception {
		setPmns();
		return SUCCESS;
	}
	
	public String listadoCategorias() {
		setCategorias(transacciones.getCategorias());
		return SUCCESS;
	}
	
	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 212);
		this.getSession().put("pmnReturn", 212);
		this.setPmn("212");
		this.setPmnReturn("212");
	}
	
	public String dirigirAgregar() throws Exception {					
		setPmns();
		return SUCCESS;
	}
	
	public String guardaCategoria() {
		CategoriasDTO categoria = new CategoriasDTO();
		categoria.setNombre(nombreCategoria.toUpperCase());
		transacciones.agregarCategoria(categoria);
		setPmns();
		return SUCCESS;
	}
	
	public String eliminaCategoria() {
		CategoriasDTO categoria = new CategoriasDTO();
		categoria.setIdCategoria(idCategoria);
		categoria.setBorrado("0");
		transacciones.eliminarCategoria(categoria);
		setPmns();
		return SUCCESS;
	}
	
	public String llamaObtenCategorias() throws Exception {	
		setCategoria(transacciones.getCategoriaById(idCategoria));
		setPmns();
		return SUCCESS;
	}
	
	public String llamaActualizaCategoria() throws Exception {
		CategoriasDTO categoria = new CategoriasDTO();
		categoria.setIdCategoria(idCategoria);
		categoria.setNombre(nombreCategoria.toUpperCase());
		transacciones.updateCategoria(categoria);
		setPmns();
		return SUCCESS;
	}

}
