package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ExcepcionesTransDTO;
import com.mx.dla.global.actions.BaseAction;

import lombok.Data;

@Data
public class ExcepcionesTransAction extends BaseAction {
	
	private List<ExcepcionesTransDTO> excepciones;
	private List<EstudiosTransDTO> estudiosTrans;
	private ExcepcionesTransDTO excepcion;
	private String nombreEstudio;
	private String titulo;
	private String revenueShare;
	private String fechaInicio;
	private String fechaFin;
	private String idExcepcion;
	
	private boolean excepcionActualizada;
	
	@Autowired
	private TransaccionesBO transacciones;
	
	@Override
	public String execute() throws Exception {
		setPmns();
		excepcionActualizada = true;
		return SUCCESS;
	}
	
	public String listadoExcepciones() {
		setExcepciones(transacciones.getExcepciones());
		return SUCCESS;
	}
	
	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 213);
		this.getSession().put("pmnReturn", 213);
		this.setPmn("213");
		this.setPmnReturn("213");
	}
	
	public String dirigirAgregar() throws Exception {
		setEstudiosTrans(transacciones.getEstudiosTrans());
		excepcionActualizada = true;
		setPmns();
		return SUCCESS;
	}
	
	public String guardaExcepcion() {
		ExcepcionesTransDTO excepcion = new ExcepcionesTransDTO();
		excepcion.setEstudio(nombreEstudio);
		excepcion.setTitulo(titulo);
		excepcion.setRevenueShare(revenueShare);
		excepcion.setFechaInicio(fechaInicio);
		excepcion.setFechaFin(fechaFin);
		if(transacciones.validaExcepcionExistente(excepcion) == null && transacciones.validaMescerrado(excepcion) == null) {
			setExcepcion(excepcion);
			transacciones.agregarExcepcion(excepcion);
			excepcionActualizada = true;
		} else {
			setExcepcion(null);
			excepcionActualizada = false;
		}
		setPmns();
		return SUCCESS;
	}
	
	public String eliminaExcepcion() {
		ExcepcionesTransDTO excepcion = new ExcepcionesTransDTO();
		excepcion.setIdExcepcion(idExcepcion);
		excepcion.setBorrado("0");
		transacciones.eliminarExcepcion(excepcion);
		setPmns();
		return SUCCESS;
	}
	
	public String llamaObtenExcepcion() throws Exception {
		setEstudiosTrans(transacciones.getEstudiosTrans());
		setExcepcion(transacciones.getExcepcionesById(idExcepcion));
		setPmns();
		return SUCCESS;
	}
	
	public String llamaActualizaExcepcion() throws Exception {
		ExcepcionesTransDTO excepcion = new ExcepcionesTransDTO();
		excepcion.setIdExcepcion(idExcepcion);
		excepcion.setEstudio(nombreEstudio);
		excepcion.setTitulo(titulo);
		excepcion.setRevenueShare(revenueShare);
		excepcion.setFechaInicio(fechaInicio);
		excepcion.setFechaFin(fechaFin);
		if(transacciones.validaMescerrado(excepcion) == null) {
			setExcepcion(excepcion);
			transacciones.updateExcepcion(excepcion);
			excepcionActualizada = true;
		} else {
			setExcepcion(null);
			excepcionActualizada = false;
		}
		setPmns();
		return SUCCESS;
	}

}
